/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportLocalPresetConfigurationScreen<T extends ConfigurationMenu>
extends ImportPresetConfigurationScreen<T> {
    private final List<ResourceLocation> localPresets;

    public ImportLocalPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.importPresetButtonLabel = "import_local_preset";
        this.importPresetHeaderLabel = "preset_local_for";
        this.localPresets = CustomPresetDataFiles.getPresetResourceLocations((SkinModel)this.getSkinModel()).toList();
    }

    @Override
    public void loadPreset(ResourceLocation resourceLocation) {
        try {
            Path presetFilePath = CustomPresetDataFiles.getPresetsResourceLocationPath((ResourceLocation)resourceLocation);
            NetworkMessageHandlerManager.getServerHandler().importLocalPreset(this.getEasyNPCUUID(), NbtIo.readCompressed((Path)presetFilePath.toFile().toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap()), resourceLocation);
        }
        catch (Exception e) {
            log.error("Failed to import local preset file {}:", (Object)resourceLocation, (Object)e);
        }
    }

    @Override
    public void init() {
        super.init();
        this.localImportPresetButton.active = false;
        ImportLocalPresetConfigurationScreen.updatePresets(this.localPresets);
        this.presetSelectionList.updatePresets();
    }
}

