/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class DisplayAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    private static final HashSet<DisplayAttributeType> TIME_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_AT_DAY, DisplayAttributeType.VISIBLE_AT_NIGHT));
    private static final HashSet<DisplayAttributeType> GAMEMODE_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_IN_CREATIVE, DisplayAttributeType.VISIBLE_IN_SPECTATOR, DisplayAttributeType.VISIBLE_IN_STANDARD));
    private static final HashSet<DisplayAttributeType> SPECIAL_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_TO_OWNER, DisplayAttributeType.VISIBLE_TO_TEAM));
    private final HashSet<Checkbox> visibilityCheckboxSet = new HashSet();
    private class_342 lightLevelBox;
    private class_4185 lightLevelSaveButton;

    public DisplayAttributeConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @Override
    public void method_25426() {
        Checkbox visibilityCheckbox;
        int checkboxTopPos;
        super.method_25426();
        this.displayAttributeButton.field_22763 = false;
        int firstButtonRow = this.leftPos + 10;
        int secondButtonRow = this.leftPos + 160;
        DisplayAttributeDataCapable displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData();
        this.lightLevelBox = (class_342)this.method_37063((class_364)new TextField(this.field_22793, firstButtonRow + 100, this.buttonTopPos + 25, 20, displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL), 2));
        this.lightLevelBox.method_1863(value -> {
            if (this.lightLevelSaveButton != null) {
                this.lightLevelSaveButton.field_22763 = ValueUtils.isNumericValue((String)value, (int)0, (int)15) && ValueUtils.getIntValue((String)value).intValue() != this.getEasyNPC().getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
            }
        });
        this.lightLevelSaveButton = (class_4185)this.method_37063((class_364)new SaveButton(this.lightLevelBox.method_46426() + this.lightLevelBox.method_25368() + 2, this.lightLevelBox.method_46427() - 1, onPress -> {
            int lightLevel = Integer.parseInt(this.lightLevelBox.method_1882());
            if (lightLevel >= 0 && lightLevel <= 15) {
                NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.LIGHT_LEVEL, lightLevel);
            }
        }));
        this.lightLevelSaveButton.field_22763 = false;
        Checkbox isVisibleCheckbox = (Checkbox)this.method_37063((class_364)new Checkbox(firstButtonRow, this.buttonTopPos + 45, DisplayAttributeType.VISIBLE.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE), checkbox -> {
            this.visibilityCheckboxSet.forEach(visibilityCheckbox -> {
                visibilityCheckbox.field_22763 = checkbox.selected();
            });
            NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.VISIBLE, checkbox.selected());
        }));
        int gamemodeCheckboxTopPos = checkboxTopPos = this.buttonTopPos + 65;
        checkboxTopPos += 15;
        gamemodeCheckboxTopPos += 15;
        for (DisplayAttributeType displayAttributeType : TIME_VISIBILITY_ATTRIBUTES) {
            visibilityCheckbox = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.field_22763 = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.method_37063((class_364)visibilityCheckbox));
            checkboxTopPos += 20;
        }
        for (DisplayAttributeType displayAttributeType : GAMEMODE_VISIBILITY_ATTRIBUTES) {
            visibilityCheckbox = new Checkbox(secondButtonRow, gamemodeCheckboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.field_22763 = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.method_37063((class_364)visibilityCheckbox));
            gamemodeCheckboxTopPos += 20;
        }
        int specialSectionY = Math.max(checkboxTopPos, gamemodeCheckboxTopPos) + 5;
        checkboxTopPos = specialSectionY + 15;
        for (DisplayAttributeType displayAttributeType : SPECIAL_VISIBILITY_ATTRIBUTES) {
            Checkbox visibilityCheckbox2 = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox2.field_22763 = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.method_37063((class_364)visibilityCheckbox2));
            checkboxTopPos += 20;
        }
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        int firstButtonRow = this.leftPos + 10;
        int secondButtonRow = this.leftPos + 160;
        if (this.lightLevelBox != null) {
            Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"light_level", (int)(this.lightLevelBox.method_46426() - 100), (int)(this.lightLevelBox.method_46427() + 4));
        }
        int timeSectionY = this.buttonTopPos + 65;
        int specialSectionY = this.buttonTopPos + 150;
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"time_visibility_settings", (int)firstButtonRow, (int)timeSectionY, (int)0x555555);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"gamemode_visibility_settings", (int)secondButtonRow, (int)timeSectionY, (int)0x555555);
        Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"special_visibility_settings", (int)firstButtonRow, (int)specialSectionY, (int)0x555555);
        if (this.getEasyNPC() != null) {
            ScreenHelper.renderScaledEntityAvatar((class_332)guiGraphics, (int)(this.leftPos + 260), (int)(this.contentTopPos + 180), (int)30, (float)((float)(this.leftPos + 50) - this.xMouse), (float)((float)(this.contentTopPos + 70) - this.yMouse), (EasyNPC)this.getEasyNPC());
        }
    }
}

