/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.main;

import de.markusbordihn.easynpc.client.screen.components.ColorButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.components.NameVisibilityToggleButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class MainConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    public static final int BUTTON_HEIGHT = 18;
    public static final int BUTTON_WIDTH = 97;
    private static final Map<String, ConfigurationType> menuButtons = new LinkedHashMap<String, ConfigurationType>();
    private class_4185 copyUUIDButton;
    private String formerName = "";
    private int formerTextColor = 0xFFFFFF;
    private NameVisibilityType formerNameVisibility = NameVisibilityType.ALWAYS;
    private class_342 nameBox;
    private ColorButton nameColorButton;
    private NameVisibilityToggleButton nameVisibilityButton;
    private class_4185 saveNameButton;
    private int avatarTopPos;

    public MainConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.contentTopPos = this.topPos + 15;
        this.avatarTopPos = this.contentTopPos + 1;
        this.homeButton.field_22764 = false;
        this.defineNameAndColorBox();
        this.defineImportExportButtons();
        this.defineUUIDButton();
        this.defineRespawnButton();
        this.defineDeleteButton();
        this.defineEditSkinButton();
        this.defineChangeModelButton();
        this.defineMenuButtons();
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        class_2338 blockPos;
        NavigationDataCapable navigationData;
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (this.getEasyNPC() == null) {
            return;
        }
        ScreenHelper.renderScaledEntityAvatar((class_332)guiGraphics, (int)(this.leftPos + 60), (int)(this.avatarTopPos + 140), (float)((float)(this.leftPos + 50) - this.xMouse), (float)((float)(this.contentTopPos + 70) - this.yMouse), (EasyNPC)this.getEasyNPC());
        float scaleEntityTypeText = 0.75f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("UUID: " + String.valueOf(this.getEasyNPCEntity().method_5667())), (int)Math.round((float)(this.contentLeftPos + 1) / scaleEntityTypeText), (int)Math.round((float)(this.buttonTopPos + 1) / scaleEntityTypeText));
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (class_2561)this.getEasyNPCEntity().method_5864().method_5897(), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 4) / scaleEntityTypeText));
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        OwnerDataCapable ownerData = this.getEasyNPC().getEasyNPCOwnerData();
        if (ownerData != null) {
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("Owner: " + (ownerData.hasNPCOwner() ? ownerData.getNPCOwnerName() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 15) / scaleEntityTypeText));
        }
        if ((navigationData = this.getEasyNPC().getEasyNPCNavigationData()) != null && navigationData.hasHomePosition()) {
            blockPos = navigationData.getHomePosition();
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("Home: " + blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 23) / scaleEntityTypeText));
        }
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("Team: " + (this.getEasyNPCEntity().method_5781() != null ? this.getEasyNPCEntity().method_5781().method_1197() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 31) / scaleEntityTypeText));
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("HP: " + this.getEasyNPCLivingEntity().method_6032() + "/" + this.getEasyNPCLivingEntity().method_6063()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 39) / scaleEntityTypeText));
        blockPos = this.getEasyNPCEntity().method_23312();
        Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)("Pos: " + blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 147) / scaleEntityTypeText));
        guiGraphics.method_51448().method_22909();
    }

    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.method_25294(this.contentLeftPos, this.avatarTopPos, this.leftPos + 117, this.avatarTopPos + 135, -16777216);
        guiGraphics.method_25294(this.leftPos + 8, this.avatarTopPos + 1, this.leftPos + 116, this.avatarTopPos + 134, -1);
        guiGraphics.method_25294(this.contentLeftPos, this.avatarTopPos + 12, this.leftPos + 117, this.avatarTopPos + 155, -16777216);
        guiGraphics.method_25294(this.leftPos + 8, this.avatarTopPos + 13, this.leftPos + 116, this.avatarTopPos + 155, -5592406);
    }

    private void defineImportExportButtons() {
        class_4185 importButton = (class_4185)this.method_37063((class_364)new TextButton(this.leftPos + 122, this.contentTopPos + 35, 97, "import", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        importButton.field_22763 = true;
        class_4185 exportButton = (class_4185)this.method_37063((class_364)new TextButton(importButton.method_46426() + importButton.method_25368() + 5, importButton.method_46427(), 97, "export", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_EXPORT)));
        exportButton.field_22763 = true;
    }

    private void defineNameAndColorBox() {
        DisplayAttributeDataCapable displayAttributeData;
        String string;
        class_2561 nameComponent = this.getEasyNPCEntity().method_5477();
        class_1767[] class_1767Array = nameComponent.method_10851();
        if (class_1767Array instanceof class_2588) {
            class_2588 translatableContents = (class_2588)class_1767Array;
            string = translatableContents.method_11022();
        } else {
            string = nameComponent.getString();
        }
        this.formerName = string;
        this.nameBox = new TextField(this.field_22793, this.contentLeftPos + 115, this.contentTopPos + 2, 138);
        this.nameBox.method_1880(32);
        this.nameBox.method_1852(this.formerName);
        this.nameBox.method_1863(consumer -> this.validateName());
        this.method_37063((class_364)this.nameBox);
        this.nameColorButton = (ColorButton)this.method_37063((class_364)new ColorButton(this.nameBox.method_46426() + this.nameBox.method_25368() + 1, this.nameBox.method_46427() - 1, onPress -> this.validateName()));
        if (this.getEasyNPCEntity().method_16914() && this.getEasyNPCEntity().method_5797().method_10866() != null && this.getEasyNPCEntity().method_5797().method_10866().method_10973() != null) {
            int styleTextColor = this.getEasyNPCEntity().method_5797().method_10866().method_10973().method_27716();
            for (class_1767 dyeColor : class_1767.values()) {
                if (dyeColor.method_16357() != styleTextColor) continue;
                this.nameColorButton.setColor(dyeColor);
                this.formerTextColor = styleTextColor;
                break;
            }
        }
        NameVisibilityType currentVisibility = (displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData()) != null ? (NameVisibilityType)displayAttributeData.getDisplayEnumAttribute(DisplayAttributeType.NAME_VISIBILITY, NameVisibilityType.class) : NameVisibilityType.ALWAYS;
        this.nameVisibilityButton = (NameVisibilityToggleButton)this.method_37063((class_364)new NameVisibilityToggleButton(this.nameColorButton.method_46426() + this.nameColorButton.method_25368() + 2, this.nameColorButton.method_46427(), currentVisibility, (button, newType) -> this.validateName()));
        this.formerNameVisibility = currentVisibility;
        this.saveNameButton = (class_4185)this.method_37063((class_364)new SaveButton(this.nameVisibilityButton.method_46426() + this.nameVisibilityButton.method_25368() + 2, this.nameVisibilityButton.method_46427(), onPress -> this.saveName()));
        this.saveNameButton.field_22763 = false;
    }

    private void defineUUIDButton() {
        this.copyUUIDButton = (class_4185)this.method_37063((class_364)new CopyButton(this.contentLeftPos, this.bottomPos - 27, 90, "copy_uuid", onPress -> {
            class_310 minecraft = class_310.method_1551();
            minecraft.field_1774.method_1455(this.getEasyNPCUUID().toString());
        }));
    }

    private void defineRespawnButton() {
        this.method_37063((class_364)new ReloadButton(this.copyUUIDButton.method_46426() + this.copyUUIDButton.method_25368() + 4, this.bottomPos - 27, 80, 16, "respawn", onPress -> this.respawnNPC()));
    }

    private void defineDeleteButton() {
        this.method_37063((class_364)new DeleteButton(this.rightPos - 70, this.bottomPos - 29, 65, onPress -> this.deleteNPC()));
    }

    protected void defineEditSkinButton() {
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        if (skinData == null) {
            return;
        }
        class_4185 editSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.contentLeftPos, this.avatarTopPos + 155, 110, 14, "edit_skin", onPress -> {
            SkinType skinType = skinData.getSkinType();
            switch (skinType) {
                case NONE: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN);
                    break;
                }
                case PLAYER_SKIN: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN);
                    break;
                }
                case CUSTOM: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        editSkinButton.field_22763 = this.supportsConfigurationType(ConfigurationType.SKIN);
    }

    protected void defineChangeModelButton() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        if (renderDataSet == null) {
            return;
        }
        boolean supportsChangeModel = this.getConfigurationData().supportsChangeModelConfiguration();
        class_4185 changeModelButton = (class_4185)this.method_37063((class_364)new TextButton(this.contentLeftPos, this.avatarTopPos + 168, 110, 14, "change_model", onPress -> {
            if (!supportsChangeModel) {
                return;
            }
            switch (renderDataSet.getRenderType()) {
                case CUSTOM_ENTITY: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_MODEL);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_MODEL);
                }
            }
        }));
        changeModelButton.field_22763 = supportsChangeModel;
        if (!supportsChangeModel) {
            changeModelButton.method_47400(class_7919.method_47407((class_2561)TextComponent.getTranslatedConfigText((String)"change_model.tooltip.only_doppler")));
        }
    }

    protected void defineMenuButtons() {
        int buttonTopPos = this.topPos + 75;
        int buttonLeftPos = this.contentLeftPos + 115;
        int buttonIndex = 0;
        for (Map.Entry<String, ConfigurationType> entry : menuButtons.entrySet()) {
            String buttonName = entry.getKey();
            ConfigurationType configurationType = entry.getValue();
            class_4185 button = (class_4185)this.method_37063((class_364)new TextButton(buttonLeftPos + buttonIndex % 2 * 102, buttonTopPos + buttonIndex / 2 * 20, 97, buttonName, onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), configurationType)));
            button.field_22763 = this.supportsConfigurationType(configurationType);
            ++buttonIndex;
        }
    }

    private void respawnNPC() {
        class_310 minecraft = this.field_22787;
        if (minecraft == null) {
            return;
        }
        minecraft.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().respawnNPC(this.getEasyNPCUUID());
                minecraft.method_1507(null);
            } else {
                minecraft.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmWarning", (class_2561)this.getEasyNPCEntity().method_5476()), (class_2561)TextComponent.getTranslatedConfigText((String)"respawnNPC.respawnButton"), class_5244.field_24335));
    }

    private void deleteNPC() {
        class_310 minecraft = this.field_22787;
        if (minecraft == null) {
            return;
        }
        minecraft.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().removeNPC(this.getEasyNPCUUID());
                minecraft.method_1507(null);
            } else {
                minecraft.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteQuestion"), (class_2561)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteWarning", (class_2561)this.getEasyNPCEntity().method_5476()), (class_2561)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteButton"), class_5244.field_24335));
    }

    private void validateName() {
        String nameValue = this.nameBox.method_1882();
        int textColorValue = this.nameColorButton.getColorValue();
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        this.saveNameButton.field_22763 = !this.formerName.equals(nameValue) || this.formerTextColor != textColorValue || this.formerNameVisibility != nameVisibility;
    }

    private void saveName() {
        String name = this.nameBox.method_1882();
        int textColor = 0xFFFFFF;
        if (this.nameColorButton != null) {
            textColor = this.nameColorButton.getColorValue();
        }
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        NetworkMessageHandlerManager.getServerHandler().changeName(this.getEasyNPC().getEntityUUID(), name, textColor, nameVisibility);
        this.formerName = name;
        this.formerTextColor = textColor;
        this.formerNameVisibility = nameVisibility;
        this.saveNameButton.field_22763 = false;
    }

    static {
        menuButtons.put("actions", ConfigurationType.BASIC_ACTION);
        menuButtons.put("attributes", ConfigurationType.ABILITIES_ATTRIBUTE);
        menuButtons.put("dialog", ConfigurationType.DIALOG);
        menuButtons.put("equipment", ConfigurationType.EQUIPMENT);
        menuButtons.put("objective", ConfigurationType.BASIC_OBJECTIVE);
        menuButtons.put("pose", ConfigurationType.POSE);
        menuButtons.put("position", ConfigurationType.DEFAULT_POSITION);
        menuButtons.put("rotation", ConfigurationType.DEFAULT_ROTATION);
        menuButtons.put("scaling", ConfigurationType.SCALING);
        menuButtons.put("trading", ConfigurationType.TRADING);
    }
}

