/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.renderer.screen;

import de.markusbordihn.easynpc.client.renderer.screen.EntityScreenRenderer;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.EntityType;

public class EntityConfigScreenRenderer
extends EntityScreenRenderer {
    private EntityConfigScreenRenderer() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        ConfigRenderState backupState = new ConfigRenderState(easyNPC);
        EntityConfigScreenRenderer.applyConfigOverrides(easyNPC, config);
        EntityScreenRenderer.renderEntity((GuiGraphics)guiGraphics, easyNPC, (EntityRenderConfig)config);
        EntityConfigScreenRenderer.restoreConfigState(easyNPC, backupState);
    }

    private static void applyConfigOverrides(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        EntityRenderOverrides overrides = config.overrides();
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData != null && renderData.getRenderDataSet() != null) {
            if (overrides.renderType() != null) {
                renderData.getRenderDataSet().setRenderType(overrides.renderType());
            }
            if (overrides.renderEntityType() != null) {
                renderData.getRenderDataSet().setRenderEntityType(overrides.renderEntityType());
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && (overrides.skinType() != null || overrides.skinUUID() != null)) {
            SkinDataEntry currentEntry = skinData.getSkinDataEntry();
            if (overrides.skinType() != null) {
                currentEntry = currentEntry.withType(overrides.skinType());
            }
            if (overrides.skinUUID() != null) {
                currentEntry = currentEntry.withUUID(overrides.skinUUID());
            }
            skinData.setSkinDataEntry(currentEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && overrides.variant() != null) {
            variantData.setSkinVariantType(overrides.variant());
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && overrides.profession() != null) {
            professionData.setProfession(overrides.profession());
        }
    }

    private static void restoreConfigState(EasyNPC<?> easyNPC, ConfigRenderState backupState) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData != null && renderData.getRenderDataSet() != null) {
            if (backupState.renderType != null) {
                renderData.getRenderDataSet().setRenderType(backupState.renderType);
            }
            if (backupState.renderEntityType != null) {
                renderData.getRenderDataSet().setRenderEntityType(backupState.renderEntityType);
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && backupState.skinDataEntry != null) {
            skinData.setSkinDataEntry(backupState.skinDataEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && backupState.variantType != null) {
            variantData.setSkinVariantType(backupState.variantType);
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && backupState.profession != null) {
            professionData.setProfession(backupState.profession);
        }
    }

    private static class ConfigRenderState {
        final RenderType renderType;
        final EntityType<?> renderEntityType;
        final SkinDataEntry skinDataEntry;
        final Enum<?> variantType;
        final Profession profession;

        ConfigRenderState(EasyNPC<?> easyNPC) {
            RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
            if (renderData != null && renderData.getRenderDataSet() != null) {
                this.renderType = renderData.getRenderDataSet().getRenderType();
                this.renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
            } else {
                this.renderType = null;
                this.renderEntityType = null;
            }
            SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
            this.skinDataEntry = skinData != null ? skinData.getSkinDataEntry() : null;
            VariantDataCapable variantData = easyNPC.getEasyNPCVariantData();
            this.variantType = variantData != null ? variantData.getSkinVariantType() : null;
            ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
            this.profession = professionData != null ? professionData.getProfession() : null;
        }
    }
}

