/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, ValueType valueType, boolean booleanValue, int integerValue, String stringValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_display_attribute");

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, ValueType.BOOLEAN, value, 0, "");
    }

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType attributeType, Integer value) {
        this(uuid, attributeType, ValueType.INTEGER, false, value, "");
    }

    public static ChangeDisplayAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeDisplayAttributeMessage(buffer.m_130259_(), (DisplayAttributeType)buffer.m_130066_(DisplayAttributeType.class), (ValueType)buffer.m_130066_(ValueType.class), buffer.readBoolean(), buffer.readInt(), buffer.m_130277_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.attributeType);
        buffer.m_130068_((Enum)this.valueType);
        buffer.writeBoolean(this.booleanValue);
        buffer.writeInt(this.integerValue);
        buffer.m_130070_(this.stringValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.valueType) {
            case BOOLEAN: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.booleanValue);
                break;
            }
            case INTEGER: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.integerValue);
                break;
            }
            case STRING: {
                AttributeHandler.setDisplayAttribute((EasyNPC)easyNPC, (DisplayAttributeType)this.attributeType, (Object)this.stringValue);
                break;
            }
            default: {
                log.error("Invalid display value type {} for {} from {}", (Object)this.valueType, (Object)easyNPC, (Object)serverPlayer);
            }
        }
    }
}

