/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;

public record ChangeModelEquipmentVisibilityMessage(UUID uuid, EquipmentSlot equipmentSlot, boolean visible) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_model_equipment_visibility");

    public static ChangeModelEquipmentVisibilityMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelEquipmentVisibilityMessage(buffer.m_130259_(), (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.equipmentSlot);
        buffer.writeBoolean(this.visible);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.equipmentSlot == null) {
            log.error("Invalid equipmentSlot for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.equipmentSlot, (Object)this.visible, (Object)easyNPC, (Object)serverPlayer);
        modelData.setModelPartVisibility(this.equipmentSlot, this.visible);
    }
}

