/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action;

import de.markusbordihn.easynpc.client.screen.components.ActionsButton;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.editor.action.ActionDataList;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ActionDataEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ActionDataSet actionDataSet;
    private final ActionEventType actionEventType = this.getAdditionalScreenData().getActionEventType();
    private final ConfigurationType configurationType = this.getAdditionalScreenData().getConfigurationType();
    private final EditorType editorType = this.getAdditionalScreenData().getEditorType();
    protected Button homeButton;
    protected Button navigationLevelOne;
    protected Button navigationLevelTwo;
    protected Button newActionDataEntryButton;
    ActionDataList actionDataList;

    public ActionDataEditorContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.actionDataSet = this.getActionDataSet();
    }

    private ActionDataSet getActionDataSet() {
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            return this.getAdditionalScreenData().getActionEventSet().getActionEvents(this.actionEventType);
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            return this.getDialogButtonData().actionDataSet();
        }
        log.error("No valid action data set found!");
        return null;
    }

    public void init() {
        super.init();
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 3, this.topPos + 3, 10, 18, "<", onPress -> this.handleBackNavigation()));
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.navigationLevelOne = (Button)this.addRenderableWidget((GuiEventListener)new ActionsButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 3, 140, this.actionEventType.name(), onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.active = false;
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelOne = (Button)this.addRenderableWidget((GuiEventListener)new DialogButtonButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 3, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID())));
        } else {
            this.navigationLevelOne = (Button)this.addRenderableWidget((GuiEventListener)new ActionsButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelOne.active = false;
        }
        if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.navigationLevelTwo = (Button)this.addRenderableWidget((GuiEventListener)new ActionsButton(this.navigationLevelOne.getX() + this.navigationLevelOne.getWidth(), this.topPos + 3, 140, "Actions", onPress -> this.navigateToActionDataEditor()));
            this.navigationLevelTwo.active = false;
        }
        this.newActionDataEntryButton = (Button)this.addRenderableWidget((GuiEventListener)new AddButton(this.leftPos + 7, this.topPos + 210, 300, "action.add", onPress -> this.handleNewActionDataEntry()));
        this.actionDataList = new ActionDataList(this.actionDataSet, this.minecraft, this.width + 50, 161, this.leftPos + 5, this.topPos + 40, this.topPos + 200, 21, this::handleMoveUpOrderActionDataEntry, this::handleMoveDownOrderActionDataEntry, this::handleEditActionDataEntry, this::handleDeleteActionDataEntry);
        this.addWidget((GuiEventListener)this.actionDataList);
    }

    private void navigateToActionDataEditor() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleBackNavigation() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), this.configurationType);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON && this.getDialogUUID() != null && this.getDialogButtonUUID() != null) {
            NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
        } else {
            log.error("No valid back navigation found!");
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
        }
    }

    private void handleNewActionDataEntry() {
        if (this.configurationType != null && this.configurationType != ConfigurationType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, new ActionDataEntry());
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry());
        } else {
            log.error("No valid new action data entry found!");
        }
    }

    private void handleDeleteActionDataEntry(ActionDataEntry actionDataEntry) {
        if (this.minecraft == null || this.actionDataSet == null || actionDataEntry == null || actionDataEntry.getId() == Constants.EMPTY_UUID) {
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.actionDataSet.remove(actionDataEntry.getId());
                if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
                    NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
                } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
                    NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
                } else {
                    log.error("Unable to delete Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
                }
                this.navigateToActionDataEditor();
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteWarning", (String)actionDataEntry.actionDataType().toString()), (Component)TextComponent.getTranslatedConfigText((String)"removeActionDataEntry.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    private void handleEditActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Editing Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.actionEventType, this.configurationType, actionDataEntry);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), this.editorType, this.getDialogUUID(), this.getDialogButtonUUID(), actionDataEntry);
        } else {
            log.error("Unable to edit action data entry {}!", (Object)actionDataEntry);
        }
    }

    private void handleMoveUpOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving up Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveUp(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move up Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    private void handleMoveDownOrderActionDataEntry(ActionDataEntry actionDataEntry) {
        log.info("Moving down Action Data Entry {}: {}", (Object)actionDataEntry.getId(), (Object)actionDataEntry);
        if (this.actionEventType != null && this.actionEventType != ActionEventType.NONE) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().actionEventChange(this.getEasyNPCUUID(), this.actionEventType, this.actionDataSet);
        } else if (this.editorType != null && this.editorType == EditorType.DIALOG_BUTTON) {
            this.actionDataSet.moveDown(actionDataEntry);
            NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), this.getDialogButtonData().withActionDataSet(this.actionDataSet));
        } else {
            log.error("Unable to move down Action Data Set {} for {}!", (Object)this.actionDataSet, (Object)this.getEasyNPCUUID());
        }
        this.navigateToActionDataEditor();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        guiGraphics.fill(this.leftPos + 5, this.topPos + 30, this.leftPos + 314, this.topPos + 200, -1118482);
        if (this.actionDataList != null) {
            this.actionDataList.render(guiGraphics, x, y, partialTicks);
        }
        this.renderHeader(guiGraphics);
        this.renderFooter(guiGraphics);
        if (this.newActionDataEntryButton != null) {
            this.newActionDataEntryButton.render(guiGraphics, x, y, partialTicks);
        }
    }

    private void renderHeader(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.leftPos + 5, this.topPos + 25, this.leftPos + 314, this.topPos + 43, -5592406);
        int headerLeft = this.leftPos + 10;
        int headerTop = this.topPos + 30;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"ID", (int)(headerLeft + 0), (int)headerTop, (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"type", (int)(headerLeft + 22), (int)headerTop, (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"value", (int)(headerLeft + 130), (int)headerTop, (int)0);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Action", (int)(headerLeft + 230), (int)headerTop, (int)0);
        int separatorTop = headerTop - 5;
        guiGraphics.fill(headerLeft + 22 - 3, separatorTop, headerLeft + 22 - 2, separatorTop + 18, -10066330);
        guiGraphics.fill(headerLeft + 130 - 3, separatorTop, headerLeft + 130 - 2, separatorTop + 18, -10066330);
        guiGraphics.fill(headerLeft + 230 - 3, separatorTop, headerLeft + 230 - 2, separatorTop + 18, -10066330);
    }

    private void renderFooter(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.leftPos + 5, this.topPos + 200, this.leftPos + 314, this.topPos + 231, -3750202);
    }
}

