/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean booleanValue, Integer integerValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_display_attribute");
    public static final CustomPacketPayload.Type<ChangeDisplayAttributeMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeDisplayAttributeMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeDisplayAttributeMessage::create);

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean value) {
        this(uuid, displayAttributeType, value, 0);
    }

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Integer value) {
        this(uuid, displayAttributeType, false, value);
    }

    public static ChangeDisplayAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeDisplayAttributeMessage(buffer.readUUID(), (DisplayAttributeType)buffer.readEnum(DisplayAttributeType.class), buffer.readBoolean(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.displayAttributeType);
        buffer.writeBoolean(this.booleanValue.booleanValue());
        buffer.writeInt(this.integerValue.intValue());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.displayAttributeType == null) {
            log.error("Invalid entity attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.integerValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.displayAttributeType, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            log.error("Unable to get display attribute data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeSet displayAttributeSet = displayAttributeData.getDisplayAttributeSet();
        if (displayAttributeSet == null) {
            log.error("Unable to get display attribute set for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(this.displayAttributeType, Boolean.TRUE.equals(this.booleanValue), this.integerValue.intValue());
        log.debug("Change display attribute {} for {} to {}", (Object)this.displayAttributeType, (Object)easyNPC, (Object)displayAttributeEntry);
        displayAttributeSet.addOrReplaceDisplayAttribute(displayAttributeEntry);
        displayAttributeData.updateDisplayAttributeSet();
        if (this.displayAttributeType == DisplayAttributeType.VISIBLE) {
            easyNPC.getEntity().setInvisible(Boolean.FALSE.equals(this.booleanValue));
        }
    }
}

