/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.ObjectiveHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record RemoveObjectiveMessage(UUID uuid, ObjectiveDataEntry objectiveDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"remove_objective");
    public static final CustomPacketPayload.Type<RemoveObjectiveMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveObjectiveMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), RemoveObjectiveMessage::create);

    public static RemoveObjectiveMessage create(FriendlyByteBuf buffer) {
        return new RemoveObjectiveMessage(buffer.readUUID(), new ObjectiveDataEntry(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeNbt((Tag)this.objectiveDataEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.objectiveDataEntry == null) {
            log.error("Invalid data to remove objective for {}: ", (Object)this);
            return;
        }
        if (!ObjectiveHandler.removeCustomObjective((EasyNPC)easyNPC, (ObjectiveDataEntry)this.objectiveDataEntry)) {
            log.error("Failed to remove objective {} for {}", (Object)this.objectiveDataEntry, (Object)easyNPC);
        }
    }
}

