/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.main;

import de.markusbordihn.easynpc.client.screen.components.ColorButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.components.NameVisibilityToggleButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;

public class MainConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    public static final int BUTTON_HEIGHT = 18;
    public static final int BUTTON_WIDTH = 97;
    private static final Map<String, ConfigurationType> menuButtons = new LinkedHashMap<String, ConfigurationType>();
    private Button copyUUIDButton;
    private String formerName = "";
    private int formerTextColor = 0xFFFFFF;
    private NameVisibilityType formerNameVisibility = NameVisibilityType.ALWAYS;
    private EditBox nameBox;
    private ColorButton nameColorButton;
    private NameVisibilityToggleButton nameVisibilityButton;
    private Button saveNameButton;
    private int avatarTopPos;

    public MainConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
    }

    @Override
    public void init() {
        super.init();
        this.contentTopPos = this.topPos + 15;
        this.avatarTopPos = this.contentTopPos + 1;
        this.homeButton.visible = false;
        this.defineNameAndColorBox();
        this.defineImportExportButtons();
        this.defineUUIDButton();
        this.defineRespawnButton();
        this.defineDeleteButton();
        this.defineEditSkinButton();
        this.defineChangeModelButton();
        this.defineMenuButtons();
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        BlockPos blockPos;
        NavigationDataCapable navigationData;
        super.render(guiGraphics, x, y, partialTicks);
        if (this.getEasyNPC() == null) {
            return;
        }
        EntityScreenRenderer.renderEntity((GuiGraphics)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)EntityRenderConfig.guiScaled((int)(this.leftPos + 60), (int)(this.avatarTopPos + 150), (int)this.getEasyNPC().getEasyNPCGuiData().getEntityGuiScaling(), (float)((float)(this.leftPos + 50) - this.xMouse), (float)((float)(this.contentTopPos + 70) - this.yMouse)), (float)this.xMouse, (float)this.yMouse);
        float scaleEntityTypeText = 0.75f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("UUID: " + String.valueOf(this.getEasyNPCEntity().getUUID())), (int)Math.round((float)(this.contentLeftPos + 1) / scaleEntityTypeText), (int)Math.round((float)(this.buttonTopPos + 1) / scaleEntityTypeText));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (Component)this.getEasyNPCEntity().getType().getDescription(), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 4) / scaleEntityTypeText));
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        OwnerDataCapable ownerData = this.getEasyNPC().getEasyNPCOwnerData();
        if (ownerData != null) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("Owner: " + (ownerData.hasNPCOwner() ? ownerData.getNPCOwnerName() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 15) / scaleEntityTypeText));
        }
        if ((navigationData = this.getEasyNPC().getEasyNPCNavigationData()) != null && navigationData.hasHomePosition()) {
            blockPos = navigationData.getHomePosition();
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("Home: " + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 23) / scaleEntityTypeText));
        }
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("Team: " + (this.getEasyNPCEntity().getTeam() != null ? this.getEasyNPCEntity().getTeam().getName() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 31) / scaleEntityTypeText));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("HP: " + this.getEasyNPCLivingEntity().getHealth() + "/" + this.getEasyNPCLivingEntity().getMaxHealth()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 39) / scaleEntityTypeText));
        blockPos = this.getEasyNPCEntity().getOnPos();
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)("Pos: " + blockPos.getX() + ", " + blockPos.getY() + ", " + blockPos.getZ()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 147) / scaleEntityTypeText));
        guiGraphics.pose().popPose();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.fill(this.contentLeftPos, this.avatarTopPos, this.leftPos + 117, this.avatarTopPos + 135, -16777216);
        guiGraphics.fill(this.leftPos + 8, this.avatarTopPos + 1, this.leftPos + 116, this.avatarTopPos + 134, -1);
        guiGraphics.fill(this.contentLeftPos, this.avatarTopPos + 12, this.leftPos + 117, this.avatarTopPos + 155, -16777216);
        guiGraphics.fill(this.leftPos + 8, this.avatarTopPos + 13, this.leftPos + 116, this.avatarTopPos + 155, -5592406);
    }

    private void defineImportExportButtons() {
        Button importButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 122, this.contentTopPos + 35, 97, "import", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        importButton.active = true;
        Button exportButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(importButton.getX() + importButton.getWidth() + 5, importButton.getY(), 97, "export", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_EXPORT)));
        exportButton.active = true;
    }

    private void defineNameAndColorBox() {
        DisplayAttributeDataCapable displayAttributeData;
        String string;
        Component nameComponent = this.getEasyNPCEntity().getName();
        DyeColor[] dyeColorArray = nameComponent.getContents();
        if (dyeColorArray instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)dyeColorArray;
            string = translatableContents.getKey();
        } else {
            string = nameComponent.getString();
        }
        this.formerName = string;
        this.nameBox = new TextField(this.font, this.contentLeftPos + 115, this.contentTopPos + 2, 138);
        this.nameBox.setMaxLength(32);
        this.nameBox.setValue(this.formerName);
        this.nameBox.setResponder(consumer -> this.validateName());
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.nameColorButton = (ColorButton)this.addRenderableWidget((GuiEventListener)new ColorButton(this.nameBox.getX() + this.nameBox.getWidth() + 1, this.nameBox.getY() - 1, onPress -> this.validateName()));
        if (this.getEasyNPCEntity().hasCustomName() && this.getEasyNPCEntity().getCustomName().getStyle() != null && this.getEasyNPCEntity().getCustomName().getStyle().getColor() != null) {
            int styleTextColor = this.getEasyNPCEntity().getCustomName().getStyle().getColor().getValue();
            for (DyeColor dyeColor : DyeColor.values()) {
                if (dyeColor.getTextColor() != styleTextColor) continue;
                this.nameColorButton.setColor(dyeColor);
                this.formerTextColor = styleTextColor;
                break;
            }
        }
        NameVisibilityType currentVisibility = (displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData()) != null ? (NameVisibilityType)displayAttributeData.getDisplayEnumAttribute(DisplayAttributeType.NAME_VISIBILITY, NameVisibilityType.class) : NameVisibilityType.ALWAYS;
        this.nameVisibilityButton = (NameVisibilityToggleButton)this.addRenderableWidget((GuiEventListener)new NameVisibilityToggleButton(this.nameColorButton.getX() + this.nameColorButton.getWidth() + 2, this.nameColorButton.getY(), currentVisibility, (button, newType) -> this.validateName()));
        this.formerNameVisibility = currentVisibility;
        this.saveNameButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.nameVisibilityButton.getX() + this.nameVisibilityButton.getWidth() + 2, this.nameVisibilityButton.getY(), onPress -> this.saveName()));
        this.saveNameButton.active = false;
    }

    private void defineUUIDButton() {
        this.copyUUIDButton = (Button)this.addRenderableWidget((GuiEventListener)new CopyButton(this.contentLeftPos, this.bottomPos - 27, 90, "copy_uuid", onPress -> {
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.keyboardHandler.setClipboard(this.getEasyNPCUUID().toString());
        }));
    }

    private void defineRespawnButton() {
        this.addRenderableWidget((GuiEventListener)new ReloadButton(this.copyUUIDButton.getX() + this.copyUUIDButton.getWidth() + 4, this.bottomPos - 27, 80, 16, "respawn", onPress -> this.respawnNPC()));
    }

    private void defineDeleteButton() {
        this.addRenderableWidget((GuiEventListener)new DeleteButton(this.rightPos - 70, this.bottomPos - 29, 65, onPress -> this.deleteNPC()));
    }

    protected void defineEditSkinButton() {
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        if (skinData == null) {
            return;
        }
        Button editSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 155, 110, 14, "edit_skin", onPress -> {
            SkinType skinType = skinData.getSkinType();
            switch (skinType) {
                case NONE: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN);
                    break;
                }
                case PLAYER_SKIN: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN);
                    break;
                }
                case CUSTOM: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        editSkinButton.active = this.supportsConfigurationType(ConfigurationType.SKIN);
    }

    protected void defineChangeModelButton() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        if (renderDataSet == null) {
            return;
        }
        boolean supportsChangeModel = this.getConfigurationData().supportsChangeModelConfiguration();
        Button changeModelButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 168, 110, 14, "change_model", onPress -> {
            if (!supportsChangeModel) {
                return;
            }
            switch (renderDataSet.getRenderType()) {
                case CUSTOM_ENTITY: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_MODEL);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_MODEL);
                }
            }
        }));
        changeModelButton.active = supportsChangeModel;
        if (!supportsChangeModel) {
            changeModelButton.setTooltip(Tooltip.create((Component)TextComponent.getTranslatedConfigText((String)"change_model.tooltip.only_doppler")));
        }
    }

    protected void defineMenuButtons() {
        int buttonTopPos = this.topPos + 75;
        int buttonLeftPos = this.contentLeftPos + 115;
        int buttonIndex = 0;
        for (Map.Entry<String, ConfigurationType> entry : menuButtons.entrySet()) {
            String buttonName = entry.getKey();
            ConfigurationType configurationType = entry.getValue();
            Button button = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(buttonLeftPos + buttonIndex % 2 * 102, buttonTopPos + buttonIndex / 2 * 20, 97, buttonName, onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), configurationType)));
            button.active = this.supportsConfigurationType(configurationType);
            ++buttonIndex;
        }
    }

    private void respawnNPC() {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().respawnNPC(this.getEasyNPCUUID());
                minecraft.setScreen(null);
            } else {
                minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmWarning", (Component)this.getEasyNPCEntity().getDisplayName()), (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.respawnButton"), CommonComponents.GUI_CANCEL));
    }

    private void deleteNPC() {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().removeNPC(this.getEasyNPCUUID());
                minecraft.setScreen(null);
            } else {
                minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteWarning", (Component)this.getEasyNPCEntity().getDisplayName()), (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    private void validateName() {
        String nameValue = this.nameBox.getValue();
        int textColorValue = this.nameColorButton.getColorValue();
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        this.saveNameButton.active = !this.formerName.equals(nameValue) || this.formerTextColor != textColorValue || this.formerNameVisibility != nameVisibility;
    }

    private void saveName() {
        String name = this.nameBox.getValue();
        int textColor = 0xFFFFFF;
        if (this.nameColorButton != null) {
            textColor = this.nameColorButton.getColorValue();
        }
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        NetworkMessageHandlerManager.getServerHandler().changeName(this.getEasyNPC().getEntityUUID(), name, textColor, nameVisibility);
        this.formerName = name;
        this.formerTextColor = textColor;
        this.formerNameVisibility = nameVisibility;
        this.saveNameButton.active = false;
    }

    static {
        menuButtons.put("actions", ConfigurationType.BASIC_ACTION);
        menuButtons.put("attributes", ConfigurationType.ABILITIES_ATTRIBUTE);
        menuButtons.put("dialog", ConfigurationType.DIALOG);
        menuButtons.put("equipment", ConfigurationType.EQUIPMENT);
        menuButtons.put("objective", ConfigurationType.BASIC_OBJECTIVE);
        menuButtons.put("pose", ConfigurationType.POSE);
        menuButtons.put("position", ConfigurationType.DEFAULT_POSITION);
        menuButtons.put("rotation", ConfigurationType.DEFAULT_ROTATION);
        menuButtons.put("scaling", ConfigurationType.SCALING);
        menuButtons.put("trading", ConfigurationType.TRADING);
    }
}

