/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.handler;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradingContainerHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private TradingContainerHandler() {
    }

    public static void setAdvancedTradingOffers(TradingDataCapable<?> tradingData, Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        int merchantOfferIndex = 0;
        for (int tradingOffer = 0; tradingOffer < 25; ++tradingOffer) {
            MerchantOffer existingMerchantOffer;
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.getItem(tradingOffer * 3);
            if (!TradingContainerHandler.isValidTradingOffer(itemA, itemB = container.getItem(tradingOffer * 3 + 1), itemResult = container.getItem(tradingOffer * 3 + 2))) continue;
            ItemCost itemCostA = TradingContainerHandler.getItemCost(itemA);
            Optional<ItemCost> itemCostB = TradingContainerHandler.getOptionalItemCost(itemB);
            MerchantOffers existingMerchantOffers = tradingData.getTradingOffers();
            MerchantOffer merchantOffer = existingMerchantOffer = existingMerchantOffers != null && existingMerchantOffers.size() > tradingOffer ? (MerchantOffer)existingMerchantOffers.get(tradingOffer) : null;
            if (existingMerchantOffer != null) {
                merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemCostA, itemCostB, itemResult, existingMerchantOffer.getUses(), existingMerchantOffer.getMaxUses(), existingMerchantOffer.getXp(), existingMerchantOffer.getPriceMultiplier(), existingMerchantOffer.getDemand()));
                continue;
            }
            merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemCostA, itemCostB, itemResult, 64, 1, 1.0f));
        }
        if (!merchantOffers.isEmpty()) {
            tradingData.getTradingDataSet().setType(TradingType.ADVANCED);
            tradingData.setTradingOffers(merchantOffers);
        }
    }

    public static void setBasicTradingOffers(TradingDataCapable<?> tradingData, Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.getItem(tradingOffer * 3);
            if (!TradingContainerHandler.isValidTradingOffer(itemA, itemB = container.getItem(tradingOffer * 3 + 1), itemResult = container.getItem(tradingOffer * 3 + 2))) continue;
            ItemCost itemCostA = TradingContainerHandler.getItemCost(itemA);
            Optional<ItemCost> itemCostB = TradingContainerHandler.getOptionalItemCost(itemB);
            MerchantOffer merchantOffer = new MerchantOffer(itemCostA, itemCostB, itemResult, tradingData.getTradingDataSet().getMaxUses(), tradingData.getTradingDataSet().getRewardedXP(), 1.0f);
            merchantOffers.add((Object)merchantOffer);
        }
        if (!merchantOffers.isEmpty()) {
            tradingData.getTradingDataSet().setType(TradingType.BASIC);
            tradingData.setTradingOffers(merchantOffers);
        }
    }

    private static boolean isValidTradingOffer(ItemStack itemA, ItemStack itemB, ItemStack itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.isEmpty() || itemB != null && !itemB.isEmpty()) && !itemResult.isEmpty();
    }

    private static ItemCost getItemCost(ItemStack itemStack) {
        return new ItemCost((ItemLike)(itemStack.isEmpty() ? ItemStack.EMPTY.getItem() : itemStack.getItem()), itemStack.getCount());
    }

    private static Optional<ItemCost> getOptionalItemCost(ItemStack itemStack) {
        return itemStack.isEmpty() ? Optional.empty() : Optional.of(TradingContainerHandler.getItemCost(itemStack));
    }
}

