/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelVisibilityMessage(UUID uuid, ModelPartType modelPartType, boolean visible) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_model_visibility");
    public static final CustomPacketPayload.Type<ChangeModelVisibilityMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeModelVisibilityMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeModelVisibilityMessage::create);

    public static ChangeModelVisibilityMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelVisibilityMessage(buffer.readUUID(), (ModelPartType)buffer.readEnum(ModelPartType.class), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.modelPartType);
        buffer.writeBoolean(this.visible);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPartType == null) {
            log.error("Invalid modelPartType for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.modelPartType, (Object)this.visible, (Object)easyNPC, (Object)serverPlayer);
        if (this.modelPartType != ModelPartType.ROOT) {
            easyNPC.getEntity().setPose(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartVisibility(this.modelPartType, this.visible);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

