/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelPositionMessage(UUID uuid, ModelPartType modelPartType, CustomPosition position) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_model_position");
    public static final CustomPacketPayload.Type<ChangeModelPositionMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeModelPositionMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeModelPositionMessage::create);

    public static ChangeModelPositionMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelPositionMessage(buffer.readUUID(), (ModelPartType)buffer.readEnum(ModelPartType.class), new CustomPosition(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.modelPartType);
        buffer.writeFloat(this.position.x());
        buffer.writeFloat(this.position.y());
        buffer.writeFloat(this.position.z());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPartType == null) {
            log.error("Invalid modelPartType for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.position == null) {
            log.error("Invalid position for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)this.modelPartType, (Object)this.position, (Object)easyNPC, (Object)serverPlayer);
        if (this.modelPartType != ModelPartType.ROOT) {
            easyNPC.getEntity().setPose(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartPosition(this.modelPartType, this.position);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

