/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.model;

import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.model.ModelConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class CustomModelConfigurationScreen<T extends ConfigurationMenu>
extends ModelConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int MAX_SKINS_PER_PAGE = 5;
    private static final int SKIN_PREVIEW_WIDTH = 60;
    private Button skinNextButton = null;
    private Button skinNextPageButton = null;
    private Button skinPreviousButton = null;
    private Button skinPreviousPageButton = null;
    private int lastNumOfSkins = 0;
    private int numOfEntities = 0;
    private int skinStartIndex = 0;
    private List<Button> customModelButtons = new ArrayList<Button>();
    private String searchFilter = null;

    public CustomModelConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.customModelButton.active = false;
        this.setDescriptionText("custom_model.text");
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
        EditBox modelSearchField = (EditBox)this.addRenderableWidget((GuiEventListener)new SearchField(this.font, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        modelSearchField.setResponder(this::onSearchFieldChanged);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 20);
        if (!this.customModelButtons.isEmpty()) {
            for (Button skinButton : this.customModelButtons) {
                skinButton.render(guiGraphics, x, y, partialTicks);
            }
        }
        this.renderCustomModels(guiGraphics);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.customModelButtons.isEmpty()) {
            for (Button skinButton : this.customModelButtons) {
                skinButton.mouseClicked(mouseX, mouseY, button);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - 5, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + 5 < this.numOfEntities ? (this.skinStartIndex += 5) : (this.numOfEntities > 5 ? this.numOfEntities - 5 : this.numOfEntities);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfEntities - 5) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    private void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.active = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.active = this.skinStartIndex + 5 < this.numOfEntities;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.active = this.skinStartIndex - 5 > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.active = this.skinStartIndex + 1 + 5 < this.numOfEntities;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(guiGraphics);
    }

    protected void updateTick() {
        super.updateTick();
        EntityTypeManager.updateUnknownEntityType((Level)this.minecraftInstance.level);
    }

    private void renderCustomModels(GuiGraphics guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.customModelButtons = new ArrayList<Button>();
        List entityKeys = EntityTypeManager.getUnknownAndSupportedEntityTypes();
        if (this.searchFilter != null && !this.searchFilter.isEmpty()) {
            entityKeys.removeIf(entityType -> !BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString().toLowerCase(Locale.ROOT).contains(this.searchFilter.toLowerCase(Locale.ROOT)));
        }
        this.numOfEntities = entityKeys.size();
        if (this.lastNumOfSkins != this.numOfEntities) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfEntities;
        }
        for (int index = this.skinStartIndex; index < this.numOfEntities && index < this.skinStartIndex + 5; ++index) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            EntityType entityType2 = (EntityType)entityKeys.get(index);
            this.renderCustomModelEntity(guiGraphics, left, top, (EntityType<Entity>)entityType2);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.pose().scale(0.7f, 0.7f, 0.7f);
            ResourceLocation entityTypeKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType2);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.normalizeString((String)entityTypeKey.getNamespace(), (int)14), (int)leftNamePos, (int)topNamePos, (int)43520);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.normalizeString((String)entityTypeKey.getPath(), (int)14), (int)leftNamePos, (int)(topNamePos + 10), (int)43520);
            guiGraphics.pose().popPose();
            ++skinPosition;
        }
    }

    private void renderCustomModelEntity(GuiGraphics guiGraphics, int x, int y, EntityType<? extends Entity> entityType) {
        SkinSelectionButton customModelButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setRenderEntityType(this.getEasyNPCUUID(), entityType));
        RenderDataCapable renderData = this.getEasyNPC().getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        EntityType currentEntityType = renderDataSet.getRenderEntityType();
        customModelButton.active = currentEntityType == null || !currentEntityType.equals(entityType);
        EntityScreenRenderer.renderEntity((GuiGraphics)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)EntityRenderConfig.customModel((int)(x + 5), (int)(y + 7), (int)Math.round(30.0f / EntityTypeManager.getScaleFactor(entityType)), (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), entityType), (float)this.xMouse, (float)this.yMouse);
        this.customModelButtons.add((Button)customModelButton);
    }

    private void renderSkinSelectionBackground(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.contentLeftPos, this.contentTopPos + 104, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 105, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

