/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class PoseConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected final ModelDataCapable<?> modelData = this.getEasyNPC().getEasyNPCModelData();
    protected Button defaultPoseButton;
    protected Button basicPoseButton;
    protected Button advancedPoseButton;
    protected Button customPoseButton;

    public PoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected RangeSliderButton createRotationSlider(int left, int top, ModelPartType modelPart, String label) {
        int sliderWidth = 34;
        int sliderHeight = 16;
        int sliderLeftPosition = left + 10;
        CustomRotation modelPartRotation = this.modelData.getModelPartRotation(modelPart);
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderLeftPosition, top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.x()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation((float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.y(), currentModelPartRotation.z()));
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonX.getX() + sliderButtonX.getWidth(), top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.y()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), (float)Math.toRadians(slider.getTargetValue()), currentModelPartRotation.z()));
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonY.getX() + sliderButtonY.getWidth(), top, sliderWidth, sliderHeight, Math.toDegrees(modelPartRotation.z()), 0.0, SliderButton.Type.DEGREE, false, slider -> {
            CustomRotation currentModelPartRotation = this.modelData.getModelPartRotation(modelPart);
            NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), modelPart, new CustomRotation(currentModelPartRotation.x(), currentModelPartRotation.y(), (float)Math.toRadians(slider.getTargetValue())));
        }));
        this.addRenderableWidget((GuiEventListener)new TextButton(left, top, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.getMessage() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.setMessage(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.setMessage(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftPosition = sliderButtonZ.getX() + sliderButtonZ.getWidth();
        this.addRenderableWidget((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)TextComponent.getText((String)"\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            NetworkMessageHandlerManager.getServerHandler().modelRotationChange(this.getEasyNPCUUID(), modelPart, CustomRotation.DEFAULT);
        }));
        return sliderButtonX;
    }

    protected RangeSliderButton createPositionSliderCompact(int left, int top, ModelPartType modelPartType, String label) {
        return this.createPositionSlider(left, top, modelPartType, label, true);
    }

    protected RangeSliderButton createPositionSlider(int left, int top, ModelPartType modelPartType, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderHeight = 16;
        int sliderLeftPosition = left + 10;
        CustomPosition modelPartPosition = this.modelData.getModelPartPosition(modelPartType);
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderLeftPosition, top, sliderWidth, sliderHeight, (double)modelPartPosition.x(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPartType, new CustomPosition(slider.getTargetValue(), currentModelPartPosition.y(), currentModelPartPosition.z()));
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonX.getX() + sliderButtonX.getWidth(), top, sliderWidth, sliderHeight, (double)modelPartPosition.y(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPartType, new CustomPosition(currentModelPartPosition.x(), slider.getTargetValue(), currentModelPartPosition.z()));
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonY.getX() + sliderButtonY.getWidth(), top, sliderWidth, sliderHeight, (double)modelPartPosition.z(), 0.0, SliderButton.Type.POSITION, false, slider -> {
            CustomPosition currentModelPartPosition = this.modelData.getModelPartPosition(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPartType, new CustomPosition(currentModelPartPosition.x(), currentModelPartPosition.y(), slider.getTargetValue()));
        }));
        this.addRenderableWidget((GuiEventListener)new TextButton(left, top, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.getMessage() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.setMessage(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.setMessage(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftPosition = sliderButtonZ.getX() + sliderButtonZ.getWidth();
        this.addRenderableWidget((GuiEventListener)new TextButton(resetButtonLeftPosition, top, 10, (Component)TextComponent.getText((String)"\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            NetworkMessageHandlerManager.getServerHandler().modelPositionChange(this.getEasyNPCUUID(), modelPartType, CustomPosition.DEFAULT);
        }));
        return sliderButtonX;
    }

    protected RangeSliderButton createScaleSliderCompact(int left, int top, ModelPartType modelPartType, String label) {
        return this.createScaleSlider(left, top, modelPartType, label, true);
    }

    protected RangeSliderButton createScaleSlider(int left, int top, ModelPartType modelPartType, String label, boolean compact) {
        int sliderWidth = 34;
        int sliderHeight = 16;
        int sliderLeftScale = left + 10;
        CustomScale modelPartScale = this.modelData.getModelPartScale(modelPartType);
        RangeSliderButton sliderButtonX = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderLeftScale, top, sliderWidth, sliderHeight, (double)modelPartScale.x(), 0.0, SliderButton.Type.SCALE, false, slider -> {
            CustomScale currentModelPartScale = this.modelData.getModelPartScale(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelScaleChange(this.getEasyNPCUUID(), modelPartType, new CustomScale(slider.getTargetValue(), currentModelPartScale.y(), currentModelPartScale.z()));
        }));
        RangeSliderButton sliderButtonY = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonX.getX() + sliderButtonX.getWidth(), top, sliderWidth, sliderHeight, (double)modelPartScale.y(), 0.0, SliderButton.Type.SCALE, false, slider -> {
            CustomScale currentModelPartScale = this.modelData.getModelPartScale(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelScaleChange(this.getEasyNPCUUID(), modelPartType, new CustomScale(currentModelPartScale.x(), slider.getTargetValue(), currentModelPartScale.z()));
        }));
        RangeSliderButton sliderButtonZ = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(sliderButtonY.getX() + sliderButtonY.getWidth(), top, sliderWidth, sliderHeight, (double)modelPartScale.z(), 0.0, SliderButton.Type.SCALE, false, slider -> {
            CustomScale currentModelPartScale = this.modelData.getModelPartScale(modelPartType);
            NetworkMessageHandlerManager.getServerHandler().modelScaleChange(this.getEasyNPCUUID(), modelPartType, new CustomScale(currentModelPartScale.x(), currentModelPartScale.y(), slider.getTargetValue()));
        }));
        this.addRenderableWidget((GuiEventListener)new TextButton(left, top, 10, RangeSliderButton.EDIT_TEXT, button -> {
            if (button.getMessage() == RangeSliderButton.EDIT_TEXT) {
                sliderButtonX.showTextField();
                sliderButtonY.showTextField();
                sliderButtonZ.showTextField();
                button.setMessage(RangeSliderButton.DONE_TEXT);
            } else {
                sliderButtonX.showSliderButton();
                sliderButtonY.showSliderButton();
                sliderButtonZ.showSliderButton();
                button.setMessage(RangeSliderButton.EDIT_TEXT);
            }
        }));
        int resetButtonLeftScale = sliderButtonZ.getX() + sliderButtonZ.getWidth();
        this.addRenderableWidget((GuiEventListener)new TextButton(resetButtonLeftScale, top, 10, (Component)TextComponent.getText((String)"\u21ba"), button -> {
            sliderButtonX.reset();
            sliderButtonY.reset();
            sliderButtonZ.reset();
            NetworkMessageHandlerManager.getServerHandler().modelScaleChange(this.getEasyNPCUUID(), modelPartType, CustomScale.DEFAULT);
        }));
        return sliderButtonX;
    }

    @Override
    public void init() {
        super.init();
        int poseButtonWidth = 74;
        this.defaultPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, poseButtonWidth - 10, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_POSE)));
        this.basicPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.defaultPoseButton.getX() + this.defaultPoseButton.getWidth(), this.buttonTopPos, poseButtonWidth, "basic", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.BASIC_POSE)));
        this.advancedPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.basicPoseButton.getX() + this.basicPoseButton.getWidth(), this.buttonTopPos, poseButtonWidth + 10, "advanced", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_POSE)));
        this.customPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.advancedPoseButton.getX() + this.advancedPoseButton.getWidth(), this.buttonTopPos, poseButtonWidth + 10, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_POSE)));
    }
}

