/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.validator.ImageValidator;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class UrlSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_DELAY = 20;
    protected Button addTextureSettingsButton = null;
    protected EditBox textureSkinLocationBox;
    private boolean canTextureSkinLocationChange = true;
    private Button clearTextureSettingsButton = null;
    private String formerTextureSkinLocation = "";
    private String errorMessage = "";

    public UrlSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set textures = RemoteTextureManager.getTextureCacheKeys((SkinModel)skinModel);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, skinModel, textureKey);
            int topNamePos = Math.round((float)(top - 76) / 0.7f);
            int leftNamePos = Math.round((float)(left - 21) / 0.7f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            guiGraphics.pose().scale(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString((String)textureKey.toString(), (int)11);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)variantName, (int)leftNamePos, (int)topNamePos, (int)43520);
            guiGraphics.pose().popPose();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(GuiGraphics guiGraphics, int x, int y, SkinModel skinModel, UUID textureUUID) {
        TextureModelKey textureModelKey = new TextureModelKey(textureUUID, skinModel);
        SkinType skinType = RemoteTextureManager.getTextureSkinType((TextureModelKey)textureModelKey);
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            String skinURL = RemoteTextureManager.getTextureSkinURL((TextureModelKey)textureModelKey);
            NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), SkinDataEntry.createRemoteSkin((String)skinURL));
        });
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.active = !skinUUID.equals(textureUUID);
        EntityConfigScreenRenderer.renderEntity(guiGraphics, this.getEasyNPC(), EntityRenderConfig.withOverrides((int)(x + 4), (int)y, (int)30, (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), (EntityRenderOverrides)EntityRenderOverrides.withSkin((SkinType)skinType, (UUID)textureUUID)), this.xMouse, this.yMouse);
        this.skinButtons.add(skinButton);
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.getValue().isEmpty()) {
            this.textureSkinLocationBox.setValue("");
        }
    }

    private void addTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.getValue();
        if (!textureSkinLocationValue.isEmpty() && !textureSkinLocationValue.equals(this.formerTextureSkinLocation)) {
            URL textureSkinLocation;
            if (!UrlValidator.isValidUrl((String)textureSkinLocationValue)) {
                this.errorMessage = "invalid_remote_image";
                return;
            }
            try {
                textureSkinLocation = new URL(textureSkinLocationValue);
            }
            catch (Exception e) {
                return;
            }
            if (!ImageValidator.isValidImage((URL)textureSkinLocation)) {
                log.error("Unable to set remote user texture to {}", (Object)textureSkinLocationValue);
                this.errorMessage = "invalid_remote_image";
                return;
            }
            log.debug("Setting remote user texture to {}", (Object)textureSkinLocationValue);
            TextureManager.clearLastErrorMessage();
            this.errorMessage = "";
            NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), SkinDataEntry.createRemoteSkin((String)textureSkinLocationValue));
            this.addTextureSettingsButton.active = false;
            this.formerTextureSkinLocation = textureSkinLocationValue;
            UrlSkinConfigurationScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.getValue();
        if (!this.canTextureSkinLocationChange) {
            this.addTextureSettingsButton.active = false;
            this.clearTextureSettingsButton.active = true;
            return;
        }
        this.addTextureSettingsButton.active = !textureSkinLocationValue.isEmpty() && UrlValidator.isValidUrl((String)textureSkinLocationValue);
        this.clearTextureSettingsButton.active = !textureSkinLocationValue.isEmpty();
    }

    @Override
    public void init() {
        super.init();
        this.urlSkinButton.active = false;
        this.setDescriptionText("url_skin.text");
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = RemoteTextureManager.getTextureCacheKeys((SkinModel)skinModel).size();
        this.textureSkinLocationBox = new TextField(this.font, this.contentLeftPos, this.contentTopPos + 50, 180);
        this.textureSkinLocationBox.setMaxLength(255);
        this.textureSkinLocationBox.setValue("");
        this.textureSkinLocationBox.setResponder(consumer -> this.validateTextureSkinLocation());
        this.addRenderableWidget((GuiEventListener)this.textureSkinLocationBox);
        this.addTextureSettingsButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.textureSkinLocationBox.getX() + this.textureSkinLocationBox.getWidth() + 2, this.contentTopPos + 50, 65, "add", onPress -> this.addTextureSkinLocation()));
        this.addTextureSettingsButton.active = false;
        this.clearTextureSettingsButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.addTextureSettingsButton.getX() + this.addTextureSettingsButton.getWidth() + 1, this.contentTopPos + 50, 55, "clear", onPress -> this.clearTextureSkinLocation()));
        this.clearTextureSettingsButton.active = false;
        this.addRenderableWidget((GuiEventListener)new Checkbox(this.contentLeftPos + 55, this.contentTopPos + 85, "disable_skin_layers", skinData.getSkinDataEntry().disableLayers(), checkbox -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), skinData.getSkinDataEntry().withDisableLayers(checkbox.selected()))));
        this.defineSkinNavigationButtons();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.addTextureSettingsButton != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"use_a_skin_url", (int)this.contentLeftPos, (int)(this.addTextureSettingsButton.getY() - 10));
        }
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        if (!this.canTextureSkinLocationChange) {
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_CONFIGURATION, (int)(this.leftPos + 176), (int)(this.contentTopPos + 53), (int)82, (int)1, (int)8, (int)10);
            if (!TextureManager.hasLastErrorMessage() && this.errorMessage.isEmpty()) {
                Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"processing_url_skin", (int)(this.leftPos + 55), (int)(this.contentTopPos + 73), (int)0xFF5555);
            }
        }
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            Text.drawErrorMessage((GuiGraphics)guiGraphics, (Font)this.font, (Component)TextComponent.getTranslatedText((String)this.errorMessage), (int)(this.leftPos + 10), (int)(this.contentTopPos + 73), (int)(this.imageWidth - 14));
        } else if (TextureManager.hasLastErrorMessage()) {
            Text.drawErrorMessage((GuiGraphics)guiGraphics, (Font)this.font, (String)TextureManager.getLastErrorMessage(), (int)(this.leftPos + 10), (int)(this.contentTopPos + 73), (int)(this.imageWidth - 14));
        }
        this.renderSkins(guiGraphics);
    }
}

