/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean booleanValue, Integer integerValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"change_display_attribute");
    public static final class_8710.class_9154<ChangeDisplayAttributeMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeDisplayAttributeMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeDisplayAttributeMessage::create);

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Boolean value) {
        this(uuid, displayAttributeType, value, 0);
    }

    public ChangeDisplayAttributeMessage(UUID uuid, DisplayAttributeType displayAttributeType, Integer value) {
        this(uuid, displayAttributeType, false, value);
    }

    public static ChangeDisplayAttributeMessage create(class_2540 buffer) {
        return new ChangeDisplayAttributeMessage(buffer.method_10790(), (DisplayAttributeType)buffer.method_10818(DisplayAttributeType.class), buffer.readBoolean(), buffer.readInt());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.displayAttributeType);
        buffer.method_52964(this.booleanValue.booleanValue());
        buffer.method_53002(this.integerValue.intValue());
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.displayAttributeType == null) {
            log.error("Invalid entity attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.integerValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.displayAttributeType, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData == null) {
            log.error("Unable to get display attribute data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeSet displayAttributeSet = displayAttributeData.getDisplayAttributeSet();
        if (displayAttributeSet == null) {
            log.error("Unable to get display attribute set for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(this.displayAttributeType, Boolean.TRUE.equals(this.booleanValue), this.integerValue.intValue());
        log.debug("Change display attribute {} for {} to {}", (Object)this.displayAttributeType, (Object)easyNPC, (Object)displayAttributeEntry);
        displayAttributeSet.addOrReplaceDisplayAttribute(displayAttributeEntry);
        displayAttributeData.updateDisplayAttributeSet();
        if (this.displayAttributeType == DisplayAttributeType.VISIBLE) {
            easyNPC.getEntity().method_5648(Boolean.FALSE.equals(this.booleanValue));
        }
    }
}

