/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportPresetConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static ResourceLocation selectedPreset;
    protected static List<ResourceLocation> presetList;
    protected Button localImportPresetButton;
    protected Button customImportPresetButton;
    protected Button defaultImportPresetButton;
    protected Button worldImportPresetButton;
    protected String importPresetButtonLabel = "import_preset";
    protected String importPresetHeaderLabel = "import_preset_header";
    protected Button importPresetButton;
    ImportFileSelectionList presetSelectionList;

    public ImportPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static void updateSelectedPreset(ResourceLocation resourceLocation) {
        selectedPreset = resourceLocation;
    }

    public static void updatePresets(List<ResourceLocation> presets) {
        presetList = presets;
    }

    public static List<ResourceLocation> getPresets() {
        return presetList;
    }

    public static boolean hasNoPresets() {
        return presetList == null || presetList.isEmpty();
    }

    public void loadPresetConfirm(ResourceLocation resourceLocation) {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                this.loadPreset(resourceLocation);
                minecraft.setScreen(null);
            } else {
                minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"preset.importQuestion", (String)resourceLocation.getPath().substring(resourceLocation.getPath().lastIndexOf("/") + 1)), (Component)TextComponent.getTranslatedConfigText((String)"preset.importWarning", (String)this.getEasyNPCEntity().getDisplayName().getString()), (Component)TextComponent.getTranslatedConfigText((String)"preset.importButton"), CommonComponents.GUI_CANCEL));
    }

    public void loadPreset(ResourceLocation resourceLocation) {
        log.error("Not implemented! Received resource location {}", (Object)resourceLocation);
    }

    public String getPresetFileName(ResourceLocation resourceLocation) {
        this.getSkinModel();
        return resourceLocation.getPath().replace("preset/" + this.getSkinModel().toString().toLowerCase(Locale.ROOT) + "/", "").replace(".npc.nbt", "");
    }

    @Override
    public void init() {
        super.init();
        int buttonWidth = 70;
        this.localImportPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth - 4, "local", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.LOCAL_PRESET_IMPORT)));
        this.defaultImportPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.localImportPresetButton.getX() + this.localImportPresetButton.getWidth(), this.buttonTopPos, buttonWidth - 4, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        this.worldImportPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.defaultImportPresetButton.getX() + this.defaultImportPresetButton.getWidth(), this.buttonTopPos, buttonWidth - 6, "world_preset", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.WORLD_PRESET_IMPORT)));
        this.customImportPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.worldImportPresetButton.getX() + this.worldImportPresetButton.getWidth(), this.buttonTopPos, buttonWidth + 15, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_IMPORT)));
        this.importPresetButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos + 25, this.bottomPos - 40, 220, this.importPresetButtonLabel, button -> {
            if (selectedPreset != null) {
                this.loadPresetConfirm(selectedPreset);
            }
        }));
        this.presetSelectionList = new ImportFileSelectionList(this.minecraft);
        this.addWidget((GuiEventListener)this.presetSelectionList);
        ImportPresetConfigurationScreen.updateSelectedPreset(null);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        if (this.presetSelectionList != null) {
            this.presetSelectionList.renderSelectionList(guiGraphics, x, y, partialTicks);
        }
        if (this.importPresetButton != null) {
            this.importPresetButton.active = selectedPreset != null;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int fileListTop = this.topPos + 55;
        int fileListHeight = fileListTop + 110;
        int fileListWidth = this.leftPos + 290;
        guiGraphics.fill(this.contentLeftPos - 1, fileListTop - 1, fileListWidth + 1, fileListHeight + 1, -16777216);
        guiGraphics.fill(this.contentLeftPos, fileListTop, fileListWidth, fileListHeight, -5592406);
    }

    class ImportFileSelectionList
    extends ObjectSelectionList<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
        public ImportFileSelectionList(Minecraft minecraft) {
            super(minecraft, ImportPresetConfigurationScreen.this.width - 22, 95, ImportPresetConfigurationScreen.this.contentTopPos + 47, 14);
            this.updatePresets();
        }

        public void updatePresets() {
            this.clearEntries();
            if (ImportPresetConfigurationScreen.hasNoPresets()) {
                return;
            }
            ImportPresetConfigurationScreen.getPresets().forEach(resourceLocation -> {
                Entry entry = new Entry((ResourceLocation)resourceLocation, ImportPresetConfigurationScreen.this.getSkinModel());
                this.addEntry((AbstractSelectionList.Entry)entry);
            });
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        protected int scrollBarY() {
            return super.scrollBarY() + 12;
        }

        public int getRowWidth() {
            return super.getRowWidth() + 40;
        }

        public boolean isFocused() {
            return ImportPresetConfigurationScreen.this.getFocused() == this;
        }

        public void renderSelectionList(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            if (this.getItemCount() > 0) {
                super.render(guiGraphics, x, y, partialTicks);
                return;
            }
            Text.drawConfigStringShadow((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.font, (String)"no_presets_found", (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 80), (int)(ImportPresetConfigurationScreen.this.topPos + 105), (int)0xFFFFFF);
        }

        public class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
            final ResourceLocation resourceLocation;
            final SkinModel skinModel;
            final String fileName;

            public Entry(ResourceLocation resourceLocation, SkinModel skinModel) {
                this.resourceLocation = resourceLocation;
                this.skinModel = skinModel;
                this.fileName = ImportPresetConfigurationScreen.this.getPresetFileName(resourceLocation);
            }

            public void render(GuiGraphics guiGraphics, int x, int y, int unused1, int unused2, int unused3, int unused4, int unused5, boolean unused6, float partialTicks) {
                int fileListTop = ImportPresetConfigurationScreen.this.topPos + 55;
                int fileListWidth = ImportPresetConfigurationScreen.this.leftPos + 290;
                guiGraphics.fill(ImportPresetConfigurationScreen.this.contentLeftPos - 1, fileListTop - 4, fileListWidth + 1, fileListTop + 12, -16777216);
                guiGraphics.fill(ImportPresetConfigurationScreen.this.contentLeftPos, fileListTop - 3, fileListWidth, fileListTop + 11, -7829368);
                Text.drawConfigStringShadowWithData((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.font, (String)ImportPresetConfigurationScreen.this.importPresetHeaderLabel, (String)this.skinModel.getName(), (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 3), (int)fileListTop, (int)0xFFFFFF);
                Text.drawStringShadow((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.font, (String)this.fileName, (int)(ImportFileSelectionList.this.width / 2 - ImportPresetConfigurationScreen.this.font.width(this.fileName) / 2), (int)(y + 1), (int)0xFFFFFF);
            }

            public boolean mouseClicked(double unused1, double unused2, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ImportFileSelectionList.this.setSelected((AbstractSelectionList.Entry)this);
                log.debug("Selected file {}.", (Object)this.resourceLocation);
                ImportPresetConfigurationScreen.updateSelectedPreset(this.resourceLocation);
            }

            public Component getNarration() {
                return TextComponent.getText((String)this.resourceLocation.getPath());
            }
        }
    }
}

