/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeAdvancedTradingMessage(UUID uuid, int tradingOfferIndex, TradingValueType tradingValueType, float tradingValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_advanced_trading");
    public static final CustomPacketPayload.Type<ChangeAdvancedTradingMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeAdvancedTradingMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeAdvancedTradingMessage::create);

    public static ChangeAdvancedTradingMessage create(FriendlyByteBuf buffer) {
        return new ChangeAdvancedTradingMessage(buffer.readUUID(), buffer.readInt(), (TradingValueType)buffer.readEnum(TradingValueType.class), buffer.readFloat());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeInt(this.tradingOfferIndex);
        buffer.writeEnum((Enum)this.tradingValueType);
        buffer.writeFloat(this.tradingValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingOfferIndex < 0) {
            log.error("Trading offer index {} is out of range (>= 0) for {}", (Object)this.tradingOfferIndex, (Object)serverPlayer);
            return;
        }
        if (this.tradingValueType == null) {
            log.error("Trading value type is unknown for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if ((double)this.tradingValue < 0.0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)Float.valueOf(this.tradingValue), (Object)this.tradingValueType, (Object)serverPlayer);
            return;
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.tradingValueType) {
            case RESET_TRADING_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)Float.valueOf(this.tradingValue), (Object)easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setResetsEveryMin((int)this.tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set advanced trading max uses {}# for {} to {} by {}", (Object)this.tradingOfferIndex, (Object)easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingMaxUses(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            case REWARD_EXP: {
                log.debug("Set advanced trading xp {}# for {} to {} by {}", (Object)this.tradingOfferIndex, (Object)easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingXp(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            case PRICE_MULTIPLIER: {
                log.debug("Set advanced trading price multiplier {}# for {} to {} by {}", (Object)this.tradingOfferIndex, (Object)easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingPriceMultiplier(this.tradingOfferIndex, this.tradingValue);
                break;
            }
            case DEMAND: {
                log.debug("Set advanced trading demand {}# for {} to {} by {}", (Object)this.tradingOfferIndex, (Object)easyNPC, (Object)Float.valueOf(this.tradingValue), (Object)serverPlayer);
                tradingData.setAdvancedTradingDemand(this.tradingOfferIndex, (int)this.tradingValue);
                break;
            }
            default: {
                log.error("Trading value type {} with value {}# for {} is unknown for {}", (Object)this.tradingValueType, (Object)Float.valueOf(this.tradingValue), (Object)this.tradingOfferIndex, (Object)serverPlayer);
            }
        }
    }
}

