/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.world.item.DyeColor;

public class ColorButton
extends CustomButton {
    public static final int DEFAULT_HEIGHT = 18;
    public static final int DEFAULT_WIDTH = 18;
    DyeColor color = DyeColor.WHITE;

    public ColorButton(int x, int y, Button.OnPress onPress) {
        this(x, y, 18, 18, onPress);
    }

    public ColorButton(int x, int y, int width, int height, Button.OnPress onPress) {
        super(x, y, width, height, onPress);
    }

    public void onClick(double x, double y) {
        int colorIndex = this.color.getId() + 1;
        if (colorIndex >= DyeColor.values().length) {
            colorIndex = 0;
        }
        this.color = DyeColor.byId((int)colorIndex);
        super.onClick(x, y);
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        super.renderButton(guiGraphics, left, top, partialTicks);
        guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + this.getWidth() - 2, this.getY() + this.getHeight() - 2, 0xFF000000 | this.getColorValue());
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public int getColorValue() {
        return this.color.getTextColor() & 0xFFFFFF;
    }
}

