/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.actions;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class ActionConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected Button basicActionButton = null;
    protected Button dialogActionButton = null;
    protected Button distanceActionButton = null;

    public ActionConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.basicActionButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, 80, "basic", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.BASIC_ACTION)));
        this.dialogActionButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.basicActionButton.getX() + this.basicActionButton.getWidth(), this.buttonTopPos, 80, "dialog_actions", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG_ACTION)));
        this.distanceActionButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.dialogActionButton.getX() + this.dialogActionButton.getWidth(), this.buttonTopPos, 80, "distance_actions", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DISTANCE_ACTION)));
    }

    protected Button getActionDataButton(int left, int top, ActionEventType actionEventType, ConfigurationType configurationType) {
        int buttonWidth = 300;
        ActionDataSet actionDataSet = this.getActionEventSet().getActionEvents(actionEventType);
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            MutableComponent buttonLabel = TextComponent.getTranslatedConfigText((String)"add_action", (Component)TextComponent.getTranslatedConfigText((String)actionEventType.name().toLowerCase(Locale.ROOT)));
            return new AddButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), actionEventType, configurationType, new ActionDataEntry())).setRenderCenter(false);
        }
        MutableComponent buttonLabel = TextComponent.getTranslatedConfigText((String)"edit_action", (Component)TextComponent.getTranslatedConfigText((String)actionEventType.name().toLowerCase(Locale.ROOT)));
        return new EditButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), actionEventType, configurationType)).setRenderCenter(false);
    }
}

