/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import java.util.EnumMap;
import java.util.Set;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class CustomPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    private final EnumMap<ModelPartType, RangeSliderButton> sliders = new EnumMap(ModelPartType.class);

    public CustomPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private RangeSliderButton createVisibilityPositionScaleRotationSlider(int left, int top, ModelPartType modelPartType, String label) {
        RangeSliderButton sliderRotationButtonX = this.createRotationSlider(left, top, modelPartType, label);
        RangeSliderButton sliderScaleButtonX = this.createScaleSliderCompact(left, top + sliderRotationButtonX.getHeight(), modelPartType, label);
        RangeSliderButton sliderPositionButtonX = this.createPositionSliderCompact(left, top + sliderRotationButtonX.getHeight() + sliderScaleButtonX.getHeight(), modelPartType, label);
        boolean modelPartVisibility = this.modelData.getModelPartVisibility(modelPartType);
        this.addRenderableWidget((GuiEventListener)new Checkbox(sliderRotationButtonX.getX() + 3, top - sliderPositionButtonX.getHeight(), "", modelPartVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), modelPartType, checkbox.selected())));
        return sliderRotationButtonX;
    }

    @Override
    public void init() {
        super.init();
        this.customPoseButton.active = false;
        int sliderTopPos = this.contentTopPos + 16;
        int sliderLeftPos = this.contentLeftPos - 3;
        int sliderLeftSpace = 200;
        int sliderTopSpace = 73;
        Set modelPartTypes = this.modelData.getModelType().getPrimaryModelParts();
        int partsOnRow = 0;
        for (ModelPartType modelPartType : modelPartTypes) {
            RangeSliderButton slider = this.createVisibilityPositionScaleRotationSlider(sliderLeftPos, sliderTopPos, modelPartType, modelPartType.name().toLowerCase());
            this.sliders.put(modelPartType, slider);
            sliderLeftPos += sliderLeftSpace;
            if (++partsOnRow < 2) continue;
            partsOnRow = 0;
            sliderLeftPos = this.contentLeftPos - 3;
            sliderTopPos += sliderTopSpace;
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        EntityConfigScreenRenderer.renderEntityRaw(guiGraphics, this.getEasyNPC(), EntityRenderConfig.customPose((int)(this.contentLeftPos + 157), (int)(this.contentTopPos + 170), (int)45, (float)((float)(this.contentLeftPos + 150) - this.xMouse), (float)((float)(this.contentTopPos + 100) - this.yMouse)), this.xMouse, this.yMouse);
        for (ModelPartType modelPartType : this.sliders.keySet()) {
            RangeSliderButton slider = this.sliders.get(modelPartType);
            if (slider == null) continue;
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)("pose." + modelPartType.name().toLowerCase()), (int)(slider.getX() + 20), (int)(slider.getY() - 12));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int backgroundTopPos = this.contentTopPos + 30;
        guiGraphics.fill(this.contentLeftPos + 109, backgroundTopPos, this.contentLeftPos + 206, this.contentTopPos + 178, -16777216);
        guiGraphics.fill(this.contentLeftPos + 110, backgroundTopPos + 1, this.contentLeftPos + 205, this.contentTopPos + 177, -5592406);
    }
}

