/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.pose;

import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.configuration.pose.PoseConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;

public class DefaultPoseConfigurationScreen<T extends ConfigurationMenu>
extends PoseConfigurationScreen<T> {
    public static final int BUTTON_WIDTH = 100;
    protected Button crouchingPoseButton;
    protected Button dyingPoseButton;
    protected Button fallFlyingPoseButton;
    protected Button longJumpPoseButton;
    protected Button sleepingPoseButton;
    protected Button spinAttackPoseButton;
    protected Button standingPoseButton;
    protected Button swimmingPoseButton;

    public DefaultPoseConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void checkPoseButtonState(Pose pose, ModelPose modelPose) {
        Pose currentPose = pose != null ? pose : this.getEasyNPCEntity().getPose();
        boolean isCustomModelPose = (modelPose != null ? modelPose : this.modelData.getModelPose()) == ModelPose.CUSTOM;
        this.standingPoseButton.active = isCustomModelPose || currentPose != Pose.STANDING;
        this.crouchingPoseButton.active = isCustomModelPose || currentPose != Pose.CROUCHING;
        this.dyingPoseButton.active = isCustomModelPose || currentPose != Pose.DYING;
        this.fallFlyingPoseButton.active = isCustomModelPose || currentPose != Pose.FALL_FLYING;
        this.longJumpPoseButton.active = isCustomModelPose || currentPose != Pose.LONG_JUMPING;
        this.sleepingPoseButton.active = isCustomModelPose || currentPose != Pose.SLEEPING;
        this.spinAttackPoseButton.active = isCustomModelPose || currentPose != Pose.SPIN_ATTACK;
        this.swimmingPoseButton.active = isCustomModelPose || currentPose != Pose.SWIMMING;
    }

    @Override
    public void init() {
        super.init();
        this.defaultPoseButton.active = false;
        int poseButtonLeft = this.contentLeftPos + 175;
        this.standingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos, 100, "pose.standing", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.STANDING);
            this.checkPoseButtonState(Pose.STANDING, ModelPose.DEFAULT);
        }));
        this.crouchingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 24, 100, "pose.crouching", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.CROUCHING);
            this.checkPoseButtonState(Pose.CROUCHING, ModelPose.DEFAULT);
        }));
        this.dyingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 48, 100, "pose.dying", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.DYING);
            this.checkPoseButtonState(Pose.DYING, ModelPose.DEFAULT);
        }));
        this.fallFlyingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 72, 100, "pose.fall_flying", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.FALL_FLYING);
            this.checkPoseButtonState(Pose.FALL_FLYING, ModelPose.DEFAULT);
        }));
        this.longJumpPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 96, 100, "pose.long_jumping", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.LONG_JUMPING);
            this.checkPoseButtonState(Pose.LONG_JUMPING, ModelPose.DEFAULT);
        }));
        this.sleepingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 120, 100, "pose.sleeping", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SLEEPING);
            this.checkPoseButtonState(Pose.SLEEPING, ModelPose.DEFAULT);
        }));
        this.spinAttackPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 144, 100, "pose.spin_attack", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SPIN_ATTACK);
            this.checkPoseButtonState(Pose.SPIN_ATTACK, ModelPose.DEFAULT);
        }));
        this.swimmingPoseButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(poseButtonLeft, this.contentTopPos + 168, 100, "pose.swimming", button -> {
            NetworkMessageHandlerManager.getServerHandler().poseChange(this.getEasyNPCUUID(), Pose.SWIMMING);
            this.checkPoseButtonState(Pose.SWIMMING, ModelPose.DEFAULT);
        }));
        this.checkPoseButtonState(this.getEasyNPCEntity().getPose(), this.modelData.getModelPose());
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        boolean entityInvisible = this.getEasyNPCEntity().isInvisible();
        this.getEasyNPCEntity().setInvisible(false);
        EntityConfigScreenRenderer.renderEntityRaw(guiGraphics, this.getEasyNPC(), EntityRenderConfig.guiScaled((int)(this.contentLeftPos + 80), (int)(this.contentTopPos + 155), (int)36, (float)((float)(this.contentLeftPos + 80) - this.xMouse), (float)((float)(this.contentTopPos + 85) - this.yMouse)), this.xMouse, this.yMouse);
        this.getEasyNPCEntity().setInvisible(entityInvisible);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.fill(this.contentLeftPos, this.contentTopPos, this.contentLeftPos + 169, this.contentTopPos + 207, -16777216);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 1, this.contentLeftPos + 168, this.contentTopPos + 206, -5592406);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 145, this.contentLeftPos + 168, this.contentTopPos + 206, -1433892728);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 145, this.contentLeftPos + 168, this.contentTopPos + 150, -1433892728);
    }
}

