/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class SkinConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SKIN_PREVIEW_WIDTH = 60;
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected static int nextSkinReload = (int)Instant.now().getEpochSecond();
    protected Button noneSkinButton = null;
    protected Button customSkinButton = null;
    protected Button defaultSkinButton = null;
    protected Button playerSkinButton = null;
    protected Button urlSkinButton = null;
    protected Button skinPreviousButton = null;
    protected Button skinNextButton = null;
    protected Button skinPreviousPageButton = null;
    protected Button skinNextPageButton = null;
    protected int skinStartIndex = 0;
    protected int numOfSkins = 0;
    protected int maxSkinsPerPage = 5;
    protected int lastNumOfSkins = 0;
    protected List<Button> skinButtons = new ArrayList<Button>();

    public SkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.active = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.active = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.active = this.skinStartIndex - this.maxSkinsPerPage > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.active = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
        }
    }

    protected void renderSkinSelectionBackground(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.contentLeftPos, this.contentTopPos + 104, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 105, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }

    @Override
    public void init() {
        super.init();
        this.noneSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, 44, "disable_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN)));
        this.defaultSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.noneSkinButton.getX() + this.noneSkinButton.getWidth(), this.buttonTopPos, 64, "default", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN)));
        this.playerSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.defaultSkinButton.getX() + this.defaultSkinButton.getWidth(), this.buttonTopPos, 62, "player_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN)));
        this.urlSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.playerSkinButton.getX() + this.playerSkinButton.getWidth(), this.buttonTopPos, 40, "url_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN)));
        this.customSkinButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.urlSkinButton.getX() + this.urlSkinButton.getWidth(), this.buttonTopPos, 80, "custom", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN)));
        TextureManager.clearLastErrorMessage();
        this.checkAccess();
        ConfigurationDataCapable configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        if (!configurationData.supportsConfigurationType(ConfigurationType.PLAYER_SKIN)) {
            this.urlSkinButton.setX(this.defaultSkinButton.getX() + this.defaultSkinButton.getWidth());
            this.customSkinButton.setX(this.urlSkinButton.getX() + this.urlSkinButton.getWidth());
            this.playerSkinButton.visible = false;
        }
    }

    private void checkAccess() {
        ConfigurationDataCapable configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        this.customSkinButton.active = configurationData.supportsConfigurationType(ConfigurationType.SKIN) && configurationData.supportsConfigurationType(ConfigurationType.CUSTOM_SKIN);
        this.defaultSkinButton.active = configurationData.supportsConfigurationType(ConfigurationType.SKIN) && configurationData.supportsConfigurationType(ConfigurationType.DEFAULT_SKIN);
        this.noneSkinButton.active = configurationData.supportsConfigurationType(ConfigurationType.SKIN) && configurationData.supportsConfigurationType(ConfigurationType.NONE_SKIN);
        this.playerSkinButton.active = configurationData.supportsConfigurationType(ConfigurationType.SKIN) && configurationData.supportsConfigurationType(ConfigurationType.PLAYER_SKIN);
        this.urlSkinButton.active = configurationData.supportsConfigurationType(ConfigurationType.SKIN) && configurationData.supportsConfigurationType(ConfigurationType.URL_SKIN);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(guiGraphics);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.mouseClicked(mouseX, mouseY, button);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void defineSkinNavigationButtons() {
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
    }

    protected void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        if (!this.skinButtons.isEmpty()) {
            for (Button skinButton : this.skinButtons) {
                skinButton.render(guiGraphics, x, y, partialTicks);
            }
        }
    }
}

