/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.item.configuration;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCWandItem
extends Item {
    public static final String ID = "easy_npc_wand";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static final int GLOWING_DURATION = 80;
    private static final double HIGHLIGHT_RADIUS = 32.0;

    public EasyNPCWandItem(Item.Properties properties) {
        super(properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)ID))));
    }

    private void highlightEasyNPC(EasyNPCBase<?> easyNPC) {
        if (easyNPC instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)easyNPC;
            pathfinderMob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 80, 0, false, false, true));
        }
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel serverLevel, Entity entity, EquipmentSlot equipmentSlot) {
        if (itemStack.is((Item)this) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!(serverPlayer.containerMenu instanceof ConfigurationMenu || equipmentSlot != EquipmentSlot.MAINHAND && equipmentSlot != EquipmentSlot.OFFHAND || serverLevel.getGameTime() % 30L != 0L)) {
                AABB searchArea = serverPlayer.getBoundingBox().inflate(32.0);
                for (PathfinderMob pathfinderMob : serverLevel.getEntitiesOfClass(PathfinderMob.class, searchArea, mob -> mob.isAlive() && mob instanceof EasyNPCBase)) {
                    this.highlightEasyNPC((EasyNPCBase)pathfinderMob);
                }
            }
        }
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (livingEntity instanceof EasyNPCBase) {
                EasyNPCBase easyNPCEntity = (EasyNPCBase)livingEntity;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, (EasyNPC<?>)easyNPCEntity, 0);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext userContext) {
        Level level = userContext.getLevel();
        Player player = userContext.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos blockPos = userContext.getClickedPos();
            AABB aabbAbove = new AABB((double)blockPos.getX() - 0.25, (double)blockPos.getY() - 2.0, (double)blockPos.getZ() - 0.25, (double)blockPos.getX() + 0.25, (double)blockPos.getY() + 2.0, (double)blockPos.getZ() + 0.25);
            for (PathfinderMob pathfinderMob : level.getEntitiesOfClass(PathfinderMob.class, aabbAbove.inflate(0.5), Entity::isAlive)) {
                if (!(pathfinderMob instanceof EasyNPCBase)) continue;
                EasyNPCBase easyNPC = (EasyNPCBase)pathfinderMob;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, (EasyNPC<?>)easyNPC, 0);
                return InteractionResult.SUCCESS;
            }
            AABB aabbAround = new AABB((double)blockPos.getX() - 0.5, (double)blockPos.getY() - 0.5, (double)blockPos.getZ() - 0.5, (double)blockPos.getX() + 1.0, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 1.0);
            for (PathfinderMob pathfinderMob : level.getEntitiesOfClass(PathfinderMob.class, aabbAround.inflate(0.5), Entity::isAlive)) {
                if (!(pathfinderMob instanceof EasyNPCBase)) continue;
                EasyNPCBase easyNPC = (EasyNPCBase)pathfinderMob;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, (EasyNPC<?>)easyNPC, 0);
                return InteractionResult.SUCCESS;
            }
            for (PathfinderMob pathfinderMob : level.getEntitiesOfClass(PathfinderMob.class, aabbAround.inflate(2.5), Entity::isAlive)) {
                if (!(pathfinderMob instanceof EasyNPCBase)) continue;
                EasyNPCBase easyNPC = (EasyNPCBase)pathfinderMob;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, (EasyNPC<?>)easyNPC, 0);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        consumer.accept((Component)TextComponent.getTranslatedTextRaw((String)"text.easy_npc_config_ui.item.easy_npc_wand"));
    }
}

