/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network;

import de.markusbordihn.easynpc.configui.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler
implements NetworkHandlerInterface {
    private static PayloadRegistrar payloadRegistrar;
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> clientMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> serverMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> registeredClientMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> registeredServerMessages = new LinkedHashMap();

    public NetworkHandler() {
        log.info("{} NetworkHandler ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
    }

    public static void registerNetworkHandler(RegisterPayloadHandlersEvent payloadHandlersEvent) {
        payloadRegistrar = payloadHandlersEvent.registrar("easy_npc_config_ui").versioned(String.valueOf(23)).optional();
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI", (Object)payloadRegistrar, (Object)23);
    }

    @Override
    public <M extends NetworkMessageRecord> void sendToServer(M networkMessageRecord) {
        if (Minecraft.getInstance().getConnection() != null) {
            Minecraft.getInstance().getConnection().send((Packet)new ServerboundCustomPayloadPacket(networkMessageRecord));
        }
    }

    @Override
    public <M extends NetworkMessageRecord> void sendToPlayer(M networkMessageRecord, ServerPlayer serverPlayer) {
        serverPlayer.connection.send((Packet)new ClientboundCustomPayloadPacket(networkMessageRecord));
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        this.logRegisterClientNetworkMessageHandler(type, networkMessage);
        payloadRegistrar.playToClient(type, codec, (customPacketPayload, playPayloadContext) -> customPacketPayload.handleClient());
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        this.logRegisterServerNetworkMessageHandler(type, networkMessage);
        payloadRegistrar.playToServer(type, codec, (customPacketPayload, playPayloadContext) -> {
            Player patt0$temp = playPayloadContext.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                customPacketPayload.handleServer(serverPlayer);
            } else {
                log.error("Unable to get valid player for network message {}", (Object)customPacketPayload);
            }
        });
    }

    @Override
    public <M extends NetworkMessageRecord> void addClientMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.clientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addServerMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.serverMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getClientMessages() {
        return this.clientMessages;
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getServerMessages() {
        return this.serverMessages;
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.registeredClientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.registeredServerMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages() {
        return this.registeredClientMessages;
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages() {
        return this.registeredServerMessages;
    }
}

