/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record ChangeActionEventMessage(UUID uuid, ActionEventType actionEventType, ActionDataSet actionDataSet) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_action_event");
    public static final CustomPacketPayload.Type<ChangeActionEventMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeActionEventMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeActionEventMessage::create);

    public static ChangeActionEventMessage create(FriendlyByteBuf buffer) {
        return new ChangeActionEventMessage(buffer.readUUID(), (ActionEventType)buffer.readEnum(ActionEventType.class), new ActionDataSet(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.actionEventType);
        buffer.writeNbt((Tag)this.actionDataSet.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.actionEventType == null || this.actionEventType == ActionEventType.NONE || this.actionDataSet == null) {
            log.error("Failed to change action event for {}: Invalid data", (Object)easyNPC);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.getServer();
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.getProfilePermissions(serverPlayer.getGameProfile());
            log.debug("Set action owner permission level {} for {} from {}", (Object)permissionLevel, (Object)easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        } else {
            log.warn("Unable to verify permission level from {} for {}", (Object)this, (Object)serverPlayer);
        }
        log.debug("Set action event {} with {} for {} from {} with owner permission level {}.", (Object)this.actionEventType, (Object)this.actionDataSet, (Object)easyNPC, (Object)serverPlayer, (Object)permissionLevel);
        actionEventData.getActionEventSet().setActionEvent(this.actionEventType, this.actionDataSet);
    }
}

