/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeTradingTypeMessage(UUID uuid, TradingType tradingType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_trading_type");
    public static final CustomPacketPayload.Type<ChangeTradingTypeMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeTradingTypeMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeTradingTypeMessage::create);

    public static ChangeTradingTypeMessage create(FriendlyByteBuf buffer) {
        return new ChangeTradingTypeMessage(buffer.readUUID(), (TradingType)buffer.readEnum(TradingType.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.tradingType);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingType == null) {
            log.error("Invalid trading type for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Invalid trading data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change trading type: {} for {} from {}", (Object)this.tradingType, (Object)easyNPC, (Object)serverPlayer);
        tradingData.getTradingDataSet().setType(this.tradingType);
        tradingData.updateTradingDataSet();
    }
}

