/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record SaveDialogButtonMessage(UUID uuid, UUID dialogId, UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"save_dialog_button");
    public static final CustomPacketPayload.Type<SaveDialogButtonMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SaveDialogButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), SaveDialogButtonMessage::create);

    public static SaveDialogButtonMessage create(FriendlyByteBuf buffer) {
        return new SaveDialogButtonMessage(buffer.readUUID(), buffer.readUUID(), buffer.readUUID(), new DialogButtonEntry(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
        buffer.writeUUID(this.dialogButtonId);
        buffer.writeNbt((Tag)this.dialogButtonEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        int permissionLevel;
        MinecraftServer minecraftServer;
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonEntry == null) {
            log.error("Invalid dialog button data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (actionEventData == null) {
            log.error("Invalid action data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId != null && !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Invalid dialog button {} for {} from {}", (Object)this.dialogButtonId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        int currentPermissionLevel = actionEventData.getActionPermissionLevel();
        if (currentPermissionLevel == 0 && (minecraftServer = serverPlayer.getServer()) != null && (permissionLevel = minecraftServer.getProfilePermissions(serverPlayer.getGameProfile())) > currentPermissionLevel) {
            log.debug("Update owner permission level from {} to {} for {} from {}", (Object)currentPermissionLevel, (Object)permissionLevel, (Object)easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        }
        if (this.dialogButtonId == null) {
            log.info("Add new dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonEntry);
        } else {
            log.info("Edit existing dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonEntry, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().getDialog(this.dialogId).setDialogButton(this.dialogButtonId, this.dialogButtonEntry);
        }
    }
}

