/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.client;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record ExportClientPresetMessage(UUID uuid, String name, SkinModel skinModel, String fileName, class_2487 data) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "preset_export_client");

    public static ExportClientPresetMessage create(class_2540 buffer) {
        return new ExportClientPresetMessage(buffer.method_10790(), buffer.method_19772(), (SkinModel)buffer.method_10818(SkinModel.class), buffer.method_19772(), buffer.method_10798());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.name);
        buffer.method_10817((Enum)this.skinModel);
        buffer.method_10814(this.fileName);
        buffer.method_10794(this.data);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)this.uuid, (Object)this);
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.error("Invalid name {} for {}", (Object)this.name, (Object)this);
            return;
        }
        if (this.skinModel == null) {
            log.error("Invalid skin model for {}", (Object)this);
            return;
        }
        if (this.data == null) {
            log.error("Invalid data for {}", (Object)this);
            return;
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            log.warn("Export preset file name is empty for {}", (Object)this.uuid);
            return;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile((SkinModel)this.skinModel, (String)this.fileName);
        if (presetFile == null) {
            log.error("Failed to get preset file for {}", (Object)this);
            return;
        }
        log.info("Exporting EasyNPC {} with UUID {} and skin {} to {}", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile);
        try {
            class_2507.method_30614((class_2487)this.data, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with UUID {} and skin {} to {}:", (Object)this.name, (Object)this.uuid, (Object)this.skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

