/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record OpenConfigurationMessage(UUID uuid, ConfigurationType configurationType, int pageIndex) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "open_configuration_screen");

    public static OpenConfigurationMessage create(class_2540 buffer) {
        return new OpenConfigurationMessage(buffer.method_10790(), (ConfigurationType)buffer.method_10818(ConfigurationType.class), buffer.readInt());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.configurationType);
        buffer.writeInt(this.pageIndex);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.configurationType == null) {
            log.error("Invalid configuration type for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)this.pageIndex, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        MenuManager.getMenuHandler().openConfigurationMenu(this.configurationType, serverPlayer, easyNPC, this.pageIndex);
    }
}

