/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record OpenDialogTextEditorMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "open_dialog_text_editor");

    public static OpenDialogTextEditorMessage create(class_2540 buffer) {
        return new OpenDialogTextEditorMessage(buffer.method_10790(), buffer.method_10790());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", (Object)easyNPC, (Object)dialogData.getDialogDataSet());
            return;
        }
        log.info("Open dialog editor with for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG_TEXT, serverPlayer, easyNPC, this.dialogId, 0);
    }
}

