/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.attribute.InteractionAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeInteractionAttributeMessage(UUID uuid, InteractionAttributeType attributeType, Boolean booleanValue, Double doubleValue, Integer integerValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_interaction_attribute");

    public ChangeInteractionAttributeMessage(UUID uuid, InteractionAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, value, 0.0, 0);
    }

    public static ChangeInteractionAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeInteractionAttributeMessage(buffer.m_130259_(), (InteractionAttributeType)buffer.m_130066_(InteractionAttributeType.class), buffer.readBoolean(), buffer.readDouble(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.attributeType);
        buffer.writeBoolean(this.booleanValue.booleanValue());
        buffer.writeDouble(this.doubleValue.doubleValue());
        buffer.writeInt(this.integerValue.intValue());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.booleanValue == null && this.doubleValue == null && this.integerValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.attributeType, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue != null) {
            AttributeHandler.setInteractionAttribute((EasyNPC)easyNPC, (InteractionAttributeType)this.attributeType, (boolean)this.booleanValue);
        }
    }
}

