/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelRotationMessage(UUID uuid, ModelPartType modelPartType, CustomRotation rotation) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_model_rotation");

    public static ChangeModelRotationMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelRotationMessage(buffer.m_130259_(), (ModelPartType)buffer.m_130066_(ModelPartType.class), new CustomRotation(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.modelPartType);
        buffer.writeFloat(this.rotation.x());
        buffer.writeFloat(this.rotation.y());
        buffer.writeFloat(this.rotation.z());
        buffer.writeBoolean(this.rotation.locked());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPartType == null) {
            log.error("Invalid modelPartType for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.rotation == null) {
            log.error("Invalid rotation for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.modelPartType == ModelPartType.ROOT) {
            modelData.setModelRotation(this.rotation.x(), this.rotation.y(), this.rotation.z());
        } else {
            log.debug("Change {} rotation to {}\u00b0 {}\u00b0 {}\u00b0 for {} from {}", (Object)this.modelPartType, (Object)Float.valueOf(this.rotation.x()), (Object)Float.valueOf(this.rotation.y()), (Object)Float.valueOf(this.rotation.z()), (Object)easyNPC, (Object)serverPlayer);
            modelData.setModelPartRotation(this.modelPartType, this.rotation);
            easyNPC.getEntity().m_20124_(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
            if (!modelData.hasChangedModel() || this.modelPartType == ModelPartType.ROOT && this.rotation.hasChanged()) {
                log.debug("Reset custom model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
                modelData.setModelPose(ModelPose.DEFAULT);
                easyNPC.getEntity().m_20124_(Pose.STANDING);
            }
        }
    }
}

