/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record ChangeSkinMessage(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariantType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_skin");

    public static ChangeSkinMessage create(FriendlyByteBuf buffer) {
        return new ChangeSkinMessage(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130259_(), (SkinType)buffer.m_130066_(SkinType.class), buffer.m_130277_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.skinName);
        buffer.m_130070_(this.skinURL);
        buffer.m_130077_(this.skinUUID);
        buffer.m_130068_((Enum)this.skinType);
        buffer.m_130070_(this.skinVariantType);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        boolean successfullyChanged;
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinName == null || this.skinType == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.skinType) {
            case NONE: {
                boolean bl = SkinHandler.setNoneSkin((EasyNPC)easyNPC);
                break;
            }
            case CUSTOM: {
                boolean bl = SkinHandler.setCustomSkin((EasyNPC)easyNPC, (UUID)this.skinUUID);
                break;
            }
            case DEFAULT: {
                boolean bl = SkinHandler.setDefaultSkin((EasyNPC)easyNPC, (String)this.skinVariantType);
                break;
            }
            case PLAYER_SKIN: {
                UUID userUUID = this.skinUUID;
                if (userUUID == null || Constants.EMPTY_UUID.equals(this.skinUUID)) {
                    log.debug("Try to convert user {} to UUID ...", (Object)this.skinName);
                    userUUID = PlayersUtils.getUserUUID((MinecraftServer)serverPlayer.m_20194_(), (String)this.skinName);
                }
                boolean bl = SkinHandler.setPlayerSkin((EasyNPC)easyNPC, (String)this.skinName, (UUID)userUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                boolean bl = SkinHandler.setRemoteSkin((EasyNPC)easyNPC, (String)this.skinURL);
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, (Object)easyNPC, (Object)serverPlayer);
                boolean bl = successfullyChanged = false;
            }
        }
        if (!successfullyChanged) {
            log.error("Failed changing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

