/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public record ImportPresetMessage(UUID uuid, PresetType presetType, CompoundTag compoundTag, ResourceLocation resourceLocation) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "import_preset");

    public static ImportPresetMessage create(FriendlyByteBuf buffer) {
        return new ImportPresetMessage(buffer.m_130259_(), (PresetType)buffer.m_130066_(PresetType.class), buffer.m_130260_(), buffer.m_130281_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.presetType);
        buffer.m_130079_(this.compoundTag);
        buffer.m_130085_(this.resourceLocation);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.presetType) {
            case LOCAL: {
                PresetHandler.importLocalPreset((ServerLevel)serverPlayer.m_284548_(), (CompoundTag)this.compoundTag, (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().m_20182_(), (UUID)this.uuid, null);
                break;
            }
            case CUSTOM: {
                PresetHandler.importCustomPreset((ServerLevel)serverPlayer.m_284548_(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().m_20182_(), (UUID)this.uuid, null);
                break;
            }
            case DATA: {
                PresetHandler.importDataPreset((ServerLevel)serverPlayer.m_284548_(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().m_20182_(), (UUID)this.uuid, null);
                break;
            }
            case DEFAULT: {
                PresetHandler.importDefaultPreset((ServerLevel)serverPlayer.m_284548_(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().m_20182_(), (UUID)this.uuid, null);
                break;
            }
            case WORLD: {
                PresetHandler.importWorldPreset((ServerLevel)serverPlayer.m_284548_(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().m_20182_(), (UUID)this.uuid, null);
                break;
            }
            default: {
                log.error("Invalid preset type {} from {}", (Object)this.presetType, (Object)serverPlayer);
            }
        }
    }
}

