/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.ObjectiveHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record RemoveObjectiveMessage(UUID uuid, ObjectiveDataEntry objectiveDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "remove_objective");

    public static RemoveObjectiveMessage create(FriendlyByteBuf buffer) {
        return new RemoveObjectiveMessage(buffer.m_130259_(), new ObjectiveDataEntry(buffer.m_130260_()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130079_(this.objectiveDataEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.objectiveDataEntry == null) {
            log.error("Invalid data to remove objective for {}: ", (Object)this);
            return;
        }
        if (!ObjectiveHandler.removeCustomObjective((EasyNPC)easyNPC, (ObjectiveDataEntry)this.objectiveDataEntry)) {
            log.error("Failed to remove objective {} for {}", (Object)this.objectiveDataEntry, (Object)easyNPC);
        }
    }
}

