/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record SaveDialogSetMessage(UUID uuid, DialogDataSet dialogDataSet) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "save_dialog_set");

    public static SaveDialogSetMessage create(FriendlyByteBuf buffer) {
        return new SaveDialogSetMessage(buffer.m_130259_(), new DialogDataSet(buffer.m_130260_()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130079_(this.dialogDataSet.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogDataSet == null) {
            log.error("Unable to get dialog data set with message {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Saving dialog {} for {} from {}", (Object)this.dialogDataSet, (Object)easyNPC, (Object)serverPlayer);
        dialogData.setDialogDataSet(this.dialogDataSet);
    }
}

