/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DisplayAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    private static final HashSet<DisplayAttributeType> TIME_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_AT_DAY, DisplayAttributeType.VISIBLE_AT_NIGHT));
    private static final HashSet<DisplayAttributeType> GAMEMODE_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_IN_CREATIVE, DisplayAttributeType.VISIBLE_IN_SPECTATOR, DisplayAttributeType.VISIBLE_IN_STANDARD));
    private static final HashSet<DisplayAttributeType> SPECIAL_VISIBILITY_ATTRIBUTES = new HashSet<DisplayAttributeType>(Arrays.asList(DisplayAttributeType.VISIBLE_TO_OWNER, DisplayAttributeType.VISIBLE_TO_TEAM));
    private final HashSet<Checkbox> visibilityCheckboxSet = new HashSet();
    private EditBox lightLevelBox;
    private Button lightLevelSaveButton;

    public DisplayAttributeConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        Checkbox visibilityCheckbox;
        int checkboxTopPos;
        super.init();
        this.displayAttributeButton.active = false;
        int firstButtonRow = this.leftPos + 10;
        int secondButtonRow = this.leftPos + 160;
        DisplayAttributeDataCapable displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData();
        this.lightLevelBox = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, firstButtonRow + 100, this.buttonTopPos + 25, 20, displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL), 2));
        this.lightLevelBox.setResponder(value -> {
            if (this.lightLevelSaveButton != null) {
                this.lightLevelSaveButton.active = ValueUtils.isNumericValue((String)value, (int)0, (int)15) && ValueUtils.getIntValue((String)value).intValue() != this.getEasyNPC().getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
            }
        });
        this.lightLevelSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.lightLevelBox.getX() + this.lightLevelBox.getWidth() + 2, this.lightLevelBox.getY() - 1, onPress -> {
            int lightLevel = Integer.parseInt(this.lightLevelBox.getValue());
            if (lightLevel >= 0 && lightLevel <= 15) {
                NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.LIGHT_LEVEL, lightLevel);
            }
        }));
        this.lightLevelSaveButton.active = false;
        Checkbox isVisibleCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 45, DisplayAttributeType.VISIBLE.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(DisplayAttributeType.VISIBLE), checkbox -> {
            this.visibilityCheckboxSet.forEach(visibilityCheckbox -> {
                visibilityCheckbox.active = checkbox.selected();
            });
            NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), DisplayAttributeType.VISIBLE, checkbox.selected());
        }));
        int gamemodeCheckboxTopPos = checkboxTopPos = this.buttonTopPos + 65;
        checkboxTopPos += 15;
        gamemodeCheckboxTopPos += 15;
        for (DisplayAttributeType displayAttributeType : TIME_VISIBILITY_ATTRIBUTES) {
            visibilityCheckbox = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.active = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.addRenderableWidget((GuiEventListener)visibilityCheckbox));
            checkboxTopPos += 20;
        }
        for (DisplayAttributeType displayAttributeType : GAMEMODE_VISIBILITY_ATTRIBUTES) {
            visibilityCheckbox = new Checkbox(secondButtonRow, gamemodeCheckboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox.active = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.addRenderableWidget((GuiEventListener)visibilityCheckbox));
            gamemodeCheckboxTopPos += 20;
        }
        int specialSectionY = Math.max(checkboxTopPos, gamemodeCheckboxTopPos) + 5;
        checkboxTopPos = specialSectionY + 15;
        for (DisplayAttributeType displayAttributeType : SPECIAL_VISIBILITY_ATTRIBUTES) {
            Checkbox visibilityCheckbox2 = new Checkbox(firstButtonRow, checkboxTopPos, displayAttributeType.getAttributeName(), displayAttributeData.getDisplayBooleanAttribute(displayAttributeType), checkbox -> NetworkMessageHandlerManager.getServerHandler().changeDisplayAttribute(this.getEasyNPCUUID(), displayAttributeType, checkbox.selected()));
            visibilityCheckbox2.active = isVisibleCheckbox.selected();
            this.visibilityCheckboxSet.add((Checkbox)this.addRenderableWidget((GuiEventListener)visibilityCheckbox2));
            checkboxTopPos += 20;
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        int firstButtonRow = this.leftPos + 10;
        int secondButtonRow = this.leftPos + 160;
        if (this.lightLevelBox != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"light_level", (int)(this.lightLevelBox.getX() - 100), (int)(this.lightLevelBox.getY() + 4));
        }
        int timeSectionY = this.buttonTopPos + 65;
        int specialSectionY = this.buttonTopPos + 150;
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"time_visibility_settings", (int)firstButtonRow, (int)timeSectionY, (int)0x555555);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"gamemode_visibility_settings", (int)secondButtonRow, (int)timeSectionY, (int)0x555555);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"special_visibility_settings", (int)firstButtonRow, (int)specialSectionY, (int)0x555555);
        if (this.getEasyNPC() != null) {
            EntityConfigScreenRenderer.renderEntity(guiGraphics, this.getEasyNPC(), EntityRenderConfig.guiScaled((int)(this.leftPos + 260), (int)(this.contentTopPos + 180), (int)30, (float)((float)(this.leftPos + 50) - this.xMouse), (float)((float)(this.contentTopPos + 70) - this.yMouse)), this.xMouse, this.yMouse);
        }
    }
}

