/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, ValueType valueType, boolean booleanValue, double doubleValue, int integerValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_combat_attribute");

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, ValueType.BOOLEAN, value, 0.0, 0);
    }

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Double value) {
        this(uuid, attributeType, ValueType.DOUBLE, false, value, 0);
    }

    public static ChangeCombatAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeCombatAttributeMessage(buffer.m_130259_(), (CombatAttributeType)buffer.m_130066_(CombatAttributeType.class), (ValueType)buffer.m_130066_(ValueType.class), buffer.readBoolean(), buffer.readDouble(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.attributeType);
        buffer.m_130068_((Enum)this.valueType);
        buffer.writeBoolean(this.booleanValue);
        buffer.writeDouble(this.doubleValue);
        buffer.writeInt(this.integerValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.valueType) {
            case BOOLEAN: {
                AttributeHandler.setCombatAttribute((EasyNPC)easyNPC, (CombatAttributeType)this.attributeType, (boolean)this.booleanValue);
                break;
            }
            case DOUBLE: {
                AttributeHandler.setCombatAttribute((EasyNPC)easyNPC, (CombatAttributeType)this.attributeType, (double)this.doubleValue);
                break;
            }
            default: {
                log.error("Invalid combat value type for {} for {} from {}", (Object)this.attributeType, (Object)easyNPC, (Object)serverPlayer);
            }
        }
    }
}

