/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelPositionMessage(UUID uuid, ModelPartType modelPartType, CustomPosition position) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_model_position");

    public static ChangeModelPositionMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelPositionMessage(buffer.m_130259_(), (ModelPartType)buffer.m_130066_(ModelPartType.class), new CustomPosition(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.modelPartType);
        buffer.writeFloat(this.position.x());
        buffer.writeFloat(this.position.y());
        buffer.writeFloat(this.position.z());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPartType == null) {
            log.error("Invalid modelPartType for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.position == null) {
            log.error("Invalid position for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)this.modelPartType, (Object)this.position, (Object)easyNPC, (Object)serverPlayer);
        if (this.modelPartType != ModelPartType.ROOT) {
            easyNPC.getEntity().m_20124_(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartPosition(this.modelPartType, this.position);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

