/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ExecuteDialogButtonActionMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "dialog_button_action");

    public static ExecuteDialogButtonActionMessage create(class_2540 buffer) {
        return new ExecuteDialogButtonActionMessage(buffer.method_10790(), buffer.method_10790(), buffer.method_10790());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
        buffer.method_10797(this.dialogButtonId);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPC(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Dialog data for {} is not available for {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Unknown dialog button action {} request for dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogButtonEntry dialogButtonEntry = dialogData.getDialogButton(this.dialogId, this.dialogButtonId);
        if (dialogButtonEntry == null) {
            log.error("Unable to get valid dialog button data for {} and dialog {} from {}", (Object)easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        ActionDataSet actionDataSet = dialogButtonEntry.actionDataSet();
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            log.error("Empty dialog button action {} request for {} and dialog {} from {}", (Object)this.dialogButtonId, (Object)easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        ActionHandler actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Unable to get valid action handler for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        actionHandler.executeActions(actionDataSet, serverPlayer);
    }
}

