/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.configui.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class CustomSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_RELOAD_DELAY = 5;
    protected class_4185 skinFolderButton = null;
    protected class_4185 skinReloadButton = null;
    protected Checkbox disableLayersCheckbox = null;
    protected class_342 skinSearchField = null;
    private String searchFilter = null;

    public CustomSkinConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    private void renderSkins(class_332 guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set textures = CustomTextureManager.getCustomTextureCacheKeys((SkinModel)skinModel, (String)this.searchFilter);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, textureKey);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            guiGraphics.method_51448().method_22905(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString((String)textureKey.toString(), (int)11);
            Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)variantName, (int)leftNamePos, (int)topNamePos, (int)43520);
            guiGraphics.method_51448().method_22909();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(class_332 guiGraphics, int x, int y, UUID textureUUID) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), SkinDataEntry.createCustomSkin((UUID)textureUUID, (this.disableLayersCheckbox != null && this.disableLayersCheckbox.selected() ? 1 : 0) != 0)));
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.field_22763 = !skinUUID.equals(textureUUID);
        EntityScreenRenderer.renderEntity((class_332)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)EntityRenderConfig.withOverrides((int)(x + 4), (int)y, (int)30, (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), (EntityRenderOverrides)EntityRenderOverrides.withSkin((SkinType)SkinType.CUSTOM, (UUID)textureUUID)), (float)this.xMouse, (float)this.yMouse);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.customSkinButton.field_22763 = false;
        this.setDescriptionText("custom_skin.text");
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = CustomTextureManager.getCustomTextureCacheKeys((SkinModel)skinModel).size();
        this.defineSkinNavigationButtons();
        Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder((SkinModel)skinModel);
        if (skinModelFolder != null) {
            this.skinFolderButton = (class_4185)this.method_37063((class_364)new TextButton(this.contentLeftPos + 10, this.contentTopPos + 65, 263, "open_textures_folder", skinModel.toString(), onPress -> class_156.method_668().method_672(skinModelFolder.toFile())));
        }
        this.skinReloadButton = (class_4185)this.method_37063((class_364)new ReloadButton(this.skinFolderButton.method_46426() + this.skinFolderButton.method_25368(), this.skinFolderButton.method_46427(), 17, 16, null, onPress -> {
            CustomSkinDataFiles.refreshRegisterTextureFiles();
            nextSkinReload = (int)Instant.now().getEpochSecond() + 5;
        }));
        this.skinSearchField = (class_342)this.method_37063((class_364)new SearchField(this.field_22793, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        this.skinSearchField.method_1863(this::onSearchFieldChanged);
        this.disableLayersCheckbox = (Checkbox)this.method_37063((class_364)new Checkbox(this.contentLeftPos + 55, this.contentTopPos + 85, "disable_skin_layers", skinData.getSkinDataEntry().disableLayers(), checkbox -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), skinData.getSkinDataEntry().withDisableLayers(checkbox.selected()))));
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.skinReloadButton != null) {
            boolean canSkinReload;
            boolean bl = canSkinReload = Instant.now().getEpochSecond() >= (long)nextSkinReload;
            if (!canSkinReload) {
                Text.drawConfigString((class_332)guiGraphics, (class_327)this.field_22793, (String)"skin_reloading", (int)(this.contentLeftPos + 55), (int)(this.contentTopPos + 143), (int)0xFF5555);
            }
            this.skinReloadButton.field_22763 = canSkinReload;
        }
        this.renderSkins(guiGraphics);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

