/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class SkinConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static final int SKIN_PREVIEW_WIDTH = 60;
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected static int nextSkinReload = (int)Instant.now().getEpochSecond();
    protected class_4185 noneSkinButton = null;
    protected class_4185 customSkinButton = null;
    protected class_4185 defaultSkinButton = null;
    protected class_4185 playerSkinButton = null;
    protected class_4185 urlSkinButton = null;
    protected class_4185 skinPreviousButton = null;
    protected class_4185 skinNextButton = null;
    protected class_4185 skinPreviousPageButton = null;
    protected class_4185 skinNextPageButton = null;
    protected int skinStartIndex = 0;
    protected int numOfSkins = 0;
    protected int maxSkinsPerPage = 5;
    protected int lastNumOfSkins = 0;
    protected List<class_4185> skinButtons = new ArrayList<class_4185>();

    public SkinConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    protected void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.field_22763 = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.field_22763 = this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.field_22763 = this.skinStartIndex - this.maxSkinsPerPage > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.field_22763 = this.skinStartIndex + 1 + this.maxSkinsPerPage < this.numOfSkins;
        }
    }

    protected void renderSkinSelectionBackground(class_332 guiGraphics) {
        guiGraphics.method_25294(this.contentLeftPos, this.contentTopPos + 104, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 1, this.contentTopPos + 105, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.noneSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos, this.buttonTopPos, 44, "disable_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN)));
        this.defaultSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.noneSkinButton.method_46426() + this.noneSkinButton.method_25368(), this.buttonTopPos, 64, "default", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN)));
        this.playerSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.defaultSkinButton.method_46426() + this.defaultSkinButton.method_25368(), this.buttonTopPos, 62, "player_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN)));
        this.urlSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.playerSkinButton.method_46426() + this.playerSkinButton.method_25368(), this.buttonTopPos, 40, "url_skin", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN)));
        this.customSkinButton = (class_4185)this.method_37063((class_364)new TextButton(this.urlSkinButton.method_46426() + this.urlSkinButton.method_25368(), this.buttonTopPos, 80, "custom", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN)));
        TextureManager.clearLastErrorMessage();
        this.checkAccess();
        ConfigurationDataCapable configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        if (!configurationData.supportsPlayerSkinConfiguration()) {
            this.urlSkinButton.method_46421(this.defaultSkinButton.method_46426() + this.defaultSkinButton.method_25368());
            this.customSkinButton.method_46421(this.urlSkinButton.method_46426() + this.urlSkinButton.method_25368());
            this.playerSkinButton.field_22764 = false;
        }
    }

    private void checkAccess() {
        ConfigurationDataCapable configurationData = this.getEasyNPC().getEasyNPCConfigurationData();
        this.customSkinButton.field_22763 = this.customSkinButton.field_22763 && configurationData.supportsSkinConfiguration() && configurationData.supportsCustomSkinConfiguration();
        this.defaultSkinButton.field_22763 = this.defaultSkinButton.field_22763 && configurationData.supportsSkinConfiguration() && configurationData.supportsDefaultSkinConfiguration();
        this.noneSkinButton.field_22763 = this.noneSkinButton.field_22763 && configurationData.supportsSkinConfiguration() && configurationData.supportsNoneSkinConfiguration();
        this.playerSkinButton.field_22763 = this.playerSkinButton.field_22763 && configurationData.supportsSkinConfiguration() && configurationData.supportsPlayerSkinConfiguration();
        this.urlSkinButton.field_22763 = this.urlSkinButton.field_22763 && configurationData.supportsSkinConfiguration() && configurationData.supportsUrlSkinConfiguration();
    }

    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(guiGraphics);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.skinButtons.isEmpty()) {
            for (class_4185 skinButton : this.skinButtons) {
                skinButton.method_25402(mouseX, mouseY, button);
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void defineSkinNavigationButtons() {
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
    }

    protected void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - this.maxSkinsPerPage, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + this.maxSkinsPerPage < this.numOfSkins ? (this.skinStartIndex += this.maxSkinsPerPage) : (this.numOfSkins > this.maxSkinsPerPage ? this.numOfSkins - this.maxSkinsPerPage : this.numOfSkins);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (class_4185)this.method_37063((class_364)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfSkins - this.maxSkinsPerPage) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (!this.skinButtons.isEmpty()) {
            for (class_4185 skinButton : this.skinButtons) {
                skinButton.method_25394(guiGraphics, x, y, partialTicks);
            }
        }
    }
}

