/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message;

import de.markusbordihn.easynpc.configui.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.configui.network.message.client.ExportClientPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.configui.network.message.client.SyncDataMessage;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ClientNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    default public void exportClientPreset(UUID uuid, String name, class_3222 serverPlayer) {
        if (name == null || name.isEmpty() || !NetworkMessageRecord.checkAccess((UUID)uuid, (class_3222)serverPlayer)) {
            return;
        }
        EasyNPC easyNPC = LivingEntityManager.getEasyNPCEntityByUUID((UUID)uuid, (class_3222)serverPlayer);
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        class_2487 compoundTag = presetData.serializePresetData();
        log.info("Exporting preset for {} to {}", (Object)easyNPC.getEntity().method_5477().getString(), (Object)serverPlayer.method_5477().getString());
        NetworkHandlerManager.sendMessageToPlayer(new ExportClientPresetMessage(uuid, easyNPC.getEntity().method_5477().getString(), easyNPC.getEasyNPCSkinData().getSkinModel(), name, compoundTag), serverPlayer);
    }

    default public void openMenu(UUID uuid, UUID menuId, class_3222 serverPlayer, class_2487 data) {
        if (uuid != null && menuId != null && serverPlayer != null) {
            log.debug("Open menu {} for npc {} and player {} with: {}", (Object)menuId, (Object)uuid, (Object)serverPlayer, (Object)data);
            NetworkHandlerManager.sendMessageToPlayer(new OpenMenuCallbackMessage(uuid, menuId, data), serverPlayer);
        }
    }

    default public void syncData(EasyNPC<?> easyNPC, class_3222 serverPlayer) {
        if (easyNPC != null && serverPlayer != null) {
            log.debug("Sync {} data to player {}", easyNPC, (Object)serverPlayer);
            NetworkHandlerManager.sendMessageToPlayer(new SyncDataMessage(easyNPC.getEntityUUID(), easyNPC.getEasyNPCDialogData() != null ? easyNPC.getEasyNPCDialogData().getDialogDataSet() : null), serverPlayer);
        }
    }
}

