/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttributeValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, EntityAttributeValueType valueType, boolean booleanValue, double doubleValue, int integerValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_combat_attribute");
    public static final CustomPacketPayload.Type<ChangeCombatAttributeMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeCombatAttributeMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeCombatAttributeMessage::create);

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Boolean value) {
        this(uuid, attributeType, EntityAttributeValueType.BOOLEAN, value, 0.0, 0);
    }

    public ChangeCombatAttributeMessage(UUID uuid, CombatAttributeType attributeType, Double value) {
        this(uuid, attributeType, EntityAttributeValueType.DOUBLE, false, value, 0);
    }

    public static ChangeCombatAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeCombatAttributeMessage(buffer.readUUID(), (CombatAttributeType)buffer.readEnum(CombatAttributeType.class), (EntityAttributeValueType)buffer.readEnum(EntityAttributeValueType.class), buffer.readBoolean(), buffer.readDouble(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.attributeType);
        buffer.writeEnum((Enum)this.valueType);
        buffer.writeBoolean(this.booleanValue);
        buffer.writeDouble(this.doubleValue);
        buffer.writeInt(this.integerValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.valueType) {
            case BOOLEAN: {
                AttributeHandler.setCombatAttribute((EasyNPC)easyNPC, (CombatAttributeType)this.attributeType, (boolean)this.booleanValue);
                break;
            }
            case DOUBLE: {
                AttributeHandler.setCombatAttribute((EasyNPC)easyNPC, (CombatAttributeType)this.attributeType, (double)this.doubleValue);
                break;
            }
            default: {
                log.error("Invalid value type for {} for {} from {}", (Object)this.attributeType, (Object)easyNPC, (Object)serverPlayer);
            }
        }
    }
}

