/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.gildedarmor.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public class GildedArmorItem
extends Item {
    public GildedArmorItem(ArmorMaterial material, ArmorType type, Item.Properties settings) {
        super(GildedArmorItem.computeSettings(material, type, settings));
    }

    private static Item.Properties computeSettings(ArmorMaterial material, ArmorType type, Item.Properties settings) {
        settings.humanoidArmor(material, ArmorType.BODY).attributes(material.createAttributes(type)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)type.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build());
        return settings;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_333372_, TooltipDisplay p_396484_, Consumer<Component> p_392123_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_333372_, p_396484_, p_392123_, p_41424_);
        p_392123_.accept((Component)Component.translatable((String)"tooltip.gildedarmor.description").withStyle(ChatFormatting.GOLD));
    }
}

