/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.gildedarmor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static final File CONFIG_FILE = new File("config/gildedarmor/gildedarmor.toml");
    public static float toughnessValueGildedArmor = 4.0f;
    public static int enchantmentValueGildedArmor = 15;
    public static float knockbackResistanceValueGildedArmor = 0.1f;
    public static int protectionValueGildedBoots = 6;
    public static int protectionValueGildedLeggings = 7;
    public static int protectionValueGildedChestplate = 10;
    public static int protectionValueGildedHelmet = 6;
    public static int durabilityValueGildedArmor = 45;

    public static void loadConfig() {
        File configDir = new File("config/gildedarmor");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!CONFIG_FILE.exists()) {
            ModConfig.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                toughnessValueGildedArmor = config.get("toughnessValueGildedArmor").getAsFloat();
                enchantmentValueGildedArmor = config.get("enchantmentValueGildedArmor").getAsInt();
                knockbackResistanceValueGildedArmor = config.get("knockbackResistanceValueGildedArmor").getAsFloat();
                protectionValueGildedBoots = config.get("protectionValueGildedBoots").getAsInt();
                protectionValueGildedLeggings = config.get("protectionValueGildedLeggings").getAsInt();
                protectionValueGildedChestplate = config.get("protectionValueGildedChestplate").getAsInt();
                protectionValueGildedHelmet = config.get("protectionValueGildedHelmet").getAsInt();
                durabilityValueGildedArmor = config.get("durabilityValueGildedArmor").getAsInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("toughnessValueGildedArmor", (Number)Float.valueOf(toughnessValueGildedArmor));
        config.addProperty("enchantmentValueGildedArmor", (Number)enchantmentValueGildedArmor);
        config.addProperty("knockbackResistanceValueGildedArmor", (Number)Float.valueOf(knockbackResistanceValueGildedArmor));
        config.addProperty("protectionValueGildedBoots", (Number)protectionValueGildedBoots);
        config.addProperty("protectionValueGildedLeggings", (Number)protectionValueGildedLeggings);
        config.addProperty("protectionValueGildedChestplate", (Number)protectionValueGildedChestplate);
        config.addProperty("protectionValueGildedHelmet", (Number)protectionValueGildedHelmet);
        config.addProperty("durabilityValueGildedArmor", (Number)durabilityValueGildedArmor);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)config));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

