/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.gildedarmor.datagen;

import com.blocklegend001.gildedarmor.item.ModItems;
import com.blocklegend001.gildedarmor.util.ModEquipmentAssets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    protected final String modId;

    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput);
        this.blockStatePathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.modId = modId;
    }

    protected void registerModels(BlockModelGenerators blockModelGenerators, ItemModelGenerators itemModels) {
        this.armorModel(itemModels, (Item)ModItems.GILDED_NETHERITE_HELMET.get(), ModEquipmentAssets.GILDED_NETHERITE);
        this.armorModel(itemModels, (Item)ModItems.GILDED_NETHERITE_CHESTPLATE.get(), ModEquipmentAssets.GILDED_NETHERITE);
        this.armorModel(itemModels, (Item)ModItems.GILDED_NETHERITE_LEGGINGS.get(), ModEquipmentAssets.GILDED_NETHERITE);
        this.armorModel(itemModels, (Item)ModItems.GILDED_NETHERITE_BOOTS.get(), ModEquipmentAssets.GILDED_NETHERITE);
    }

    public void armorModel(ItemModelGenerators itemModels, Item item, ResourceKey<EquipmentAsset> equipmentKey) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String armorType = "";
        if (id.getPath().contains("helmet")) {
            armorType = "helmet";
        } else if (id.getPath().contains("chestplate")) {
            armorType = "chestplate";
        } else if (id.getPath().contains("leggings")) {
            armorType = "leggings";
        } else if (id.getPath().contains("boots")) {
            armorType = "boots";
        }
        itemModels.generateTrimmableItem(item, equipmentKey, ResourceLocation.withDefaultNamespace((String)("trims/items/" + armorType + "_trim")), false);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ModelProvider.ItemInfoCollector itemCollector = new ModelProvider.ItemInfoCollector(this::getKnownItems);
        ModelProvider.BlockStateGeneratorCollector blockStateCollector = new ModelProvider.BlockStateGeneratorCollector(this::getKnownBlocks);
        ModelProvider.SimpleModelCollector simpleModelCollector = new ModelProvider.SimpleModelCollector();
        this.registerModels(new BlockModelGenerators((Consumer)blockStateCollector, (ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector), new ItemModelGenerators((ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector));
        blockStateCollector.validate();
        itemCollector.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateCollector.save(output, this.blockStatePathProvider), simpleModelCollector.save(output, this.modelPathProvider), itemCollector.save(output, this.itemInfoPathProvider));
    }

    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }

    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> Optional.of(BuiltInRegistries.ITEM.getKey(item)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }
}

