/*
 * Decompiled with CFR 0.152.
 */
package net.swzo.brassworksmissions.client.gui;

import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum MissionGuiTextures implements ScreenElement,
TextureSheetSegment
{
    BUTTON("custom_widgets", 0, 0, 18, 18),
    BUTTON_HOVER("custom_widgets", 18, 0, 18, 18),
    BUTTON_DOWN("custom_widgets", 36, 0, 18, 18),
    BUTTON_DISABLED("custom_widgets", 54, 0, 18, 18);

    public final ResourceLocation location;
    private final int width;
    private final int height;
    private final int startX;
    private final int startY;

    private MissionGuiTextures(String location, int startX, int startY, int width, int height) {
        this("brassworksmissions", location, startX, startY, width, height);
    }

    private MissionGuiTextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/gui/" + location + ".png"));
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.location, x, y, this.getStartX(), this.getStartY(), this.getWidth(), this.getHeight());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((GuiGraphics)graphics, (Color)c, (int)x, (int)y, (int)this.getStartX(), (int)this.getStartY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

